/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.compat.patchouli;

import java.util.List;
import java.util.Optional;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class RitualTableProcessor
implements IComponentProcessor {
    private RitualTableRecipe recipe;

    private static HolderLookup.Provider regs(Level level) {
        Level ctx;
        Object object = ctx = level != null ? level : Minecraft.getInstance().level;
        if (ctx == null) {
            throw new IllegalStateException("No level available for RitualTableProcessor");
        }
        return ctx.registryAccess();
    }

    private static Level ctx(Level level) {
        return level != null ? level : Minecraft.getInstance().level;
    }

    public void setup(Level level, IVariableProvider variables) {
        HolderLookup.Provider reg = RitualTableProcessor.regs(level);
        String recipeIdStr = variables.get("recipe", reg).asString();
        ResourceLocation recipeId = ResourceLocation.parse((String)recipeIdStr);
        Level world = RitualTableProcessor.ctx(level);
        List all = world.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.RITUAL_TABLE_TYPE.get());
        Optional<RitualTableRecipe> match = all.stream().filter(r -> r.id().equals((Object)recipeId)).map(RecipeHolder::value).findFirst();
        this.recipe = match.orElseThrow(() -> new IllegalArgumentException("Ritual Table recipe not found: " + String.valueOf(recipeId)));
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        HolderLookup.Provider reg = RitualTableProcessor.regs(level);
        if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.getResultItem(reg), (HolderLookup.Provider)reg);
        }
        if (key.equals("header")) {
            return IVariable.from((Object)this.recipe.getResultItem(reg).getHoverName(), (HolderLookup.Provider)reg);
        }
        if (key.equals("input_main")) {
            if (!this.recipe.getIngredients().isEmpty()) {
                Ingredient main = (Ingredient)this.recipe.getIngredients().getFirst();
                ItemStack[] stacks = main.getItems();
                ItemStack stack = stacks.length > 0 ? stacks[0] : ItemStack.EMPTY;
                return IVariable.from((Object)stack, (HolderLookup.Provider)reg);
            }
            return IVariable.from((Object)ItemStack.EMPTY, (HolderLookup.Provider)reg);
        }
        if (key.startsWith("input_brazier")) {
            try {
                int idx;
                int ingIndex = idx = Integer.parseInt(key.substring("input_brazier".length()));
                if (ingIndex >= 1 && ingIndex < this.recipe.getIngredients().size()) {
                    Ingredient ing = (Ingredient)this.recipe.getIngredients().get(ingIndex);
                    ItemStack[] stacks = ing.getItems();
                    ItemStack stack = stacks.length > 0 ? stacks[0] : ItemStack.EMPTY;
                    return IVariable.from((Object)stack, (HolderLookup.Provider)reg);
                }
                return IVariable.from((Object)ItemStack.EMPTY, (HolderLookup.Provider)reg);
            }
            catch (NumberFormatException e) {
                return IVariable.from((Object)ItemStack.EMPTY, (HolderLookup.Provider)reg);
            }
        }
        return null;
    }
}

