/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen.custom;

import java.util.LinkedHashMap;
import java.util.Map;
import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RitualTableRecipeBuilder
implements RecipeBuilder {
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private final ItemStack output;
    private final Item result;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public RitualTableRecipeBuilder(ItemStack output) {
        this.output = output;
        this.result = output.getItem();
    }

    public static RitualTableRecipeBuilder ritualTableRecipe(ItemStack output) {
        return new RitualTableRecipeBuilder(output);
    }

    public RitualTableRecipeBuilder addIngredient(Ingredient ingredient) {
        this.ingredients.add((Object)ingredient);
        return this;
    }

    public RitualTableRecipeBuilder addIngredient(Item item) {
        return this.addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public RitualTableRecipeBuilder addIngredient(ItemStack stack) {
        return this.addIngredient(Ingredient.of((ItemStack[])new ItemStack[]{stack}));
    }

    public RitualTableRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RitualTableRecipeBuilder unlockedByItem(String name, Item item) {
        return this.unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
    }

    public RitualTableRecipeBuilder unlockedByItems(String name, Item ... items) {
        return this.unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public RecipeBuilder group(@Nullable String s) {
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients defined for Ritual Table recipe");
        }
        if (this.ingredients.size() > 5) {
            throw new IllegalStateException("Too many ingredients for Ritual Table recipe (max 5)");
        }
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        RitualTableRecipe recipe = new RitualTableRecipe(this.ingredients, this.output);
        output.accept(id, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/ritual_table/")));
    }
}

