/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.effect.custom;

import net.astralya.hexalia.util.SunlightCheck;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DaybloomEffect
extends MobEffect {
    private static final int COOLDOWN = 100;
    private static final ResourceLocation RESOURCE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"daybloom");

    public DaybloomEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!(entity instanceof Player)) {
            return super.applyEffectTick(entity, amplifier);
        }
        Player player = (Player)entity;
        Level level = player.level();
        SunlightCheck sun = new SunlightCheck(level, player.blockPosition());
        sun.recheckCanSeeSun();
        float gen = sun.getGenerationMultiplier();
        if (gen <= 0.0f) {
            player.hurt(player.damageSources().magic(), 1.5f);
            this.removeSpeedModifier(player);
        } else {
            float healAmount = 2.0f * gen;
            player.heal(healAmount);
            this.applySpeedModifier(player, amplifier, gen);
        }
        return true;
    }

    private void applySpeedModifier(Player player, int amplifier, float sunlightScale) {
        AttributeInstance attr = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attr == null) {
            return;
        }
        this.removeSpeedModifier(player);
        double base = 0.05 * (double)(amplifier + 1);
        double scaled = base * (double)sunlightScale;
        if (scaled != 0.0) {
            attr.addTransientModifier(new AttributeModifier(RESOURCE_LOCATION, scaled, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    private void removeSpeedModifier(Player player) {
        AttributeInstance attr = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attr != null) {
            attr.removeModifier(RESOURCE_LOCATION);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 100 == 0;
    }
}

