/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.effect.custom;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;

public class OverfedEffect
extends MobEffect {
    public OverfedEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.getCommandSenderWorld().isClientSide() && livingEntity instanceof Player) {
            boolean isPlayerHealing;
            Player player = (Player)livingEntity;
            FoodData foodData = player.getFoodData();
            boolean bl = isPlayerHealing = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION) && player.isHurt() && foodData.getFoodLevel() >= 18;
            if (!isPlayerHealing) {
                float exhaustion = foodData.getExhaustionLevel();
                float reduce = Math.min(exhaustion, 4.0f);
                if (exhaustion > 0.0f) {
                    player.causeFoodExhaustion(-reduce);
                }
            }
            return true;
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

