/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.entity.custom.projectile;

import java.util.List;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.effect.ModEffectCure;
import net.astralya.hexalia.entity.ModEntities;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class PurifyingSacProjectile
extends ThrowableItemProjectile {
    public PurifyingSacProjectile(EntityType<? extends PurifyingSacProjectile> type, Level level) {
        super(type, level);
    }

    public PurifyingSacProjectile(Level level) {
        super(ModEntities.PURIFYING_SAC.get(), level);
    }

    public PurifyingSacProjectile(Level level, LivingEntity owner) {
        super(ModEntities.PURIFYING_SAC.get(), owner, level);
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.PURIFYING_SAC.get();
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    protected void onHit(HitResult hit) {
        super.onHit(hit);
        if (!this.level().isClientSide) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSoundEvents.SAC_IMPACT.get(), SoundSource.PLAYERS, 0.9f, 0.8f + this.level().getRandom().nextFloat() * 0.4f);
            this.spawnLingeringCloudAndCleanse();
            this.discard();
        }
    }

    private void spawnLingeringCloudAndCleanse() {
        LivingEntity le;
        if (this.level().isClientSide) {
            return;
        }
        int durationSeconds = Math.max(1, (Integer)Configuration.PURIFYING_SAC_DURATION.get());
        AreaEffectCloud cloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        cloud.setOwner(entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null);
        cloud.setRadius(3.0f);
        cloud.setRadiusPerTick(-3.0f / ((float)durationSeconds * 20.0f));
        cloud.setDuration(durationSeconds * 20);
        cloud.setWaitTime(0);
        int rgb = 13625855;
        int argb = FastColor.ARGB32.opaque((int)rgb);
        cloud.setParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)argb));
        float r = cloud.getRadius();
        AABB aabb = new AABB(this.getX() - (double)r, this.getY() - 1.0, this.getZ() - (double)r, this.getX() + (double)r, this.getY() + 1.0, this.getZ() + (double)r);
        List targets = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
        for (LivingEntity target : targets) {
            double dz;
            double dx = target.getX() - this.getX();
            if (!(dx * dx + (dz = target.getZ() - this.getZ()) * dz <= (double)(r * r))) continue;
            target.removeEffectsCuredBy(ModEffectCure.PURIFYING);
        }
        this.level().addFreshEntity((Entity)cloud);
        this.discard();
    }
}

