/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.particle.custom;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class GhostParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    protected GhostParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteSet) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.spriteSet = spriteSet;
        this.friction = 0.92f;
        this.gravity = 0.05f;
        this.xd *= 0.25;
        this.yd *= 0.25;
        this.zd *= 0.25;
        this.setSpriteFromAge(spriteSet);
        this.quadSize = 0.2f;
        this.lifetime = 30;
        this.alpha = 0.8f;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.spriteSet);
        this.alpha = 0.8f * (1.0f - (float)this.age / (float)this.lifetime);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public float getQuadSize(float scaleFactor) {
        float ageRatio = ((float)this.age + scaleFactor) / (float)this.lifetime;
        return this.quadSize * (0.8f - ageRatio * ageRatio * 0.3f);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new GhostParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.spriteSet);
        }
    }
}

