/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.RitualBrazierRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record RitualBrazierRecipe(Ingredient inputItem, ItemStack output) implements Recipe<RitualBrazierRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.inputItem);
        return list;
    }

    public boolean matches(RitualBrazierRecipeInput input, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.inputItem.test(input.getItem(0));
    }

    public ItemStack assemble(RitualBrazierRecipeInput input, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.RITUAL_BRAZIER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.RITUAL_BRAZIER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<RitualBrazierRecipe> {
        public static final MapCodec<RitualBrazierRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(RitualBrazierRecipe::inputItem), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("output").xmap(ItemStack::new, ItemStack::getItem).forGetter(RitualBrazierRecipe::output)).apply((Applicative)inst, RitualBrazierRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RitualBrazierRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RitualBrazierRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, RitualBrazierRecipe::output, RitualBrazierRecipe::new);

        public MapCodec<RitualBrazierRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RitualBrazierRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

