/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.util;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public final class SunlightCheck {
    private final Level level;
    private BlockPos pos;
    private final boolean needsRainCheck;
    private final float peakMultiplier;
    private boolean canSeeSun;

    public SunlightCheck(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
        Biome biome = (Biome)this.level.getBiomeManager().getBiome(this.pos).value();
        this.needsRainCheck = biome.getPrecipitationAt(this.pos) != Biome.Precipitation.NONE;
        float tempEff = 0.3f * (0.8f - biome.getBaseTemperature());
        float humidityEff = this.needsRainCheck ? -0.3f * biome.getModifiedClimateSettings().downfall() : 0.0f;
        this.peakMultiplier = 1.0f + tempEff + humidityEff;
    }

    public void moveTo(BlockPos newPos) {
        this.pos = newPos;
        this.recheckCanSeeSun();
    }

    public void recheckCanSeeSun() {
        this.canSeeSun = SunlightCheck.canSeeSun(this.level, this.pos);
    }

    public boolean canSeeSunNow() {
        return this.canSeeSun;
    }

    public float getPeakMultiplier() {
        return this.peakMultiplier;
    }

    public float getGenerationMultiplier() {
        if (!this.canSeeSun) {
            return 0.0f;
        }
        if (this.needsRainCheck && (this.level.isRaining() || this.level.isThundering())) {
            return this.peakMultiplier * 0.2f;
        }
        return this.peakMultiplier;
    }

    public static float getSunBrightness(Level level, float partialTicks) {
        float t = level.getTimeOfDay(partialTicks);
        float curve = 1.0f - (Mth.cos((float)(t * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        curve = Mth.clamp((float)curve, (float)0.0f, (float)1.0f);
        curve = 1.0f - curve;
        curve = (float)((double)curve * (1.0 - (double)(level.getRainLevel(partialTicks) * 5.0f) / 16.0));
        curve = (float)((double)curve * (1.0 - (double)(level.getThunderLevel(partialTicks) * 5.0f) / 16.0));
        return curve * 0.8f + 0.2f;
    }

    public static boolean canSeeSun(Level level, BlockPos pos) {
        if (level == null) {
            return false;
        }
        if (!level.dimensionType().hasSkyLight()) {
            return false;
        }
        if (level.getSkyDarken() >= 4) {
            return false;
        }
        return level.canSeeSky(pos);
    }
}

