/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.util;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TeleportUtil {
    public static boolean canReturn(Level level, Player player, boolean allowInterdimensional) {
        if (level.isClientSide()) {
            return false;
        }
        ResourceKey spawnDim = ((ServerPlayer)player).getRespawnDimension();
        return !allowInterdimensional && level.dimension() != spawnDim;
    }

    public static void teleportPlayerToSpawn(Level currentWorld, Player player, boolean allowInterdimensional) {
        if (currentWorld.isClientSide() || TeleportUtil.canReturn(currentWorld, player, allowInterdimensional)) {
            return;
        }
        ServerLevel targetWorld = TeleportUtil.getTargetWorld(currentWorld, player);
        player.stopRiding();
        if (player.isSleeping()) {
            player.stopSleeping();
        }
        if (targetWorld != null) {
            Optional<Vec3> pos;
            BlockPos spawnPoint = TeleportUtil.getSpawnPointPosition(player, targetWorld);
            if (spawnPoint != null && (pos = TeleportUtil.findRespawnPosition(targetWorld, spawnPoint, player)).isPresent()) {
                TeleportUtil.doReturn(player, currentWorld, targetWorld, pos.get().x, pos.get().y, pos.get().z);
                return;
            }
            BlockPos fallback = targetWorld.getSharedSpawnPos();
            TeleportUtil.doReturn(player, currentWorld, targetWorld, (double)fallback.getX() + 0.5, fallback.getY(), (double)fallback.getZ() + 0.5);
        }
    }

    private static ServerLevel getTargetWorld(Level currentWorld, Player player) {
        ResourceKey spawnDim = ((ServerPlayer)player).getRespawnDimension();
        return currentWorld.dimension() == spawnDim ? (ServerLevel)currentWorld : Objects.requireNonNull(currentWorld.getServer()).getLevel(spawnDim);
    }

    private static BlockPos getSpawnPointPosition(Player player, ServerLevel serverLevel) {
        return player instanceof ServerPlayer ? ((ServerPlayer)player).getRespawnPosition() : null;
    }

    private static Optional<Vec3> findRespawnPosition(ServerLevel world, BlockPos spawnPoint, Player player) {
        return TeleportUtil.findSafeRespawnPosition(world, spawnPoint);
    }

    private static Optional<Vec3> findSafeRespawnPosition(ServerLevel world, BlockPos spawnPoint) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int yOffset = 0; yOffset <= 2; ++yOffset) {
            boolean hasSpace;
            mutable.set(spawnPoint.getX(), spawnPoint.getY() + yOffset, spawnPoint.getZ());
            boolean bl = hasSpace = world.getBlockState((BlockPos)mutable).getCollisionShape((BlockGetter)world, (BlockPos)mutable).isEmpty() && world.getBlockState(mutable.above()).getCollisionShape((BlockGetter)world, mutable.above()).isEmpty();
            if (!hasSpace) continue;
            return Optional.of(new Vec3((double)mutable.getX() + 0.5, (double)mutable.getY(), (double)mutable.getZ() + 0.5));
        }
        return Optional.empty();
    }

    private static void doReturn(Player player, Level origin, ServerLevel target, double x, double y, double z) {
        TeleportUtil.playTeleportSound(player, target, x, y, z);
        if (origin != target) {
            ((ServerPlayer)player).teleportTo(target, x, y, z, player.getYRot(), player.getXRot());
        } else {
            player.teleportTo(x, y, z);
        }
        if (player.fallDistance > 0.0f) {
            player.fallDistance = 0.0f;
        }
        TeleportUtil.playTeleportSound(player, target, x, y, z);
    }

    private static void playTeleportSound(Player player, ServerLevel world, double x, double y, double z) {
        world.playSound(null, x, y, z, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

