/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.worldgen;

import java.util.List;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.worldgen.ModConfiguredFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> SPIRIT_BLOOM_PLACED = ModPlacedFeatures.registerKey("spirit_bloom_placed");
    public static final ResourceKey<PlacedFeature> DREAMSHROOM_PLACED = ModPlacedFeatures.registerKey("dreamshroom_placed");
    public static final ResourceKey<PlacedFeature> SIREN_KELP_PLACED = ModPlacedFeatures.registerKey("siren_kelp_placed");
    public static final ResourceKey<PlacedFeature> CHILLBERRY_PLACED = ModPlacedFeatures.registerKey("chillberry_placed");
    public static final ResourceKey<PlacedFeature> WILD_SUNFIRE_TOMATO_PLACED = ModPlacedFeatures.registerKey("wild_sunfire_tomato_placed");
    public static final ResourceKey<PlacedFeature> WILD_MANDRAKE_PLACED = ModPlacedFeatures.registerKey("wild_mandrake_placed");
    public static final ResourceKey<PlacedFeature> GHOST_FERN_PLACED = ModPlacedFeatures.registerKey("ghost_fern_placed");
    public static final ResourceKey<PlacedFeature> CELESTIAL_BLOOM_PLACED = ModPlacedFeatures.registerKey("celestial_bloom_placed");
    public static final ResourceKey<PlacedFeature> BEGONIA_PLACED = ModPlacedFeatures.registerKey("begonia_placed");
    public static final ResourceKey<PlacedFeature> LAVENDER_PLACED = ModPlacedFeatures.registerKey("lavender_placed");
    public static final ResourceKey<PlacedFeature> DAHLIA_PLACED = ModPlacedFeatures.registerKey("dahlia_placed");
    public static final ResourceKey<PlacedFeature> LOTUS_FLOWER_PLACED = ModPlacedFeatures.registerKey("lotus_flower_placed");
    public static final ResourceKey<PlacedFeature> PALE_MUSHROOM_PLACED = ModPlacedFeatures.registerKey("pale_mushroom_placed");
    public static final ResourceKey<PlacedFeature> WITCHWEED_PLACED = ModPlacedFeatures.registerKey("witchweed_placed");
    public static final ResourceKey<PlacedFeature> NIGHTSHADE_BUSH_PLACED = ModPlacedFeatures.registerKey("nightshade_bush_placed");
    public static final ResourceKey<PlacedFeature> COTTONWOOD_PLACED = ModPlacedFeatures.registerKey("cottonwood_placed");
    public static final ResourceKey<PlacedFeature> WILLOW_PLACED = ModPlacedFeatures.registerKey("willow_placed");
    public static final ResourceKey<PlacedFeature> DARK_OAK_COCOON_PLACED = ModPlacedFeatures.registerKey("dark_oak_cocoon_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configured = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, SPIRIT_BLOOM_PLACED, configured.getOrThrow(ModConfiguredFeatures.SPIRIT_BLOOM), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, DREAMSHROOM_PLACED, configured.getOrThrow(ModConfiguredFeatures.DREAMSHROOM), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, SIREN_KELP_PLACED, configured.getOrThrow(ModConfiguredFeatures.SIREN_KELP), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, CHILLBERRY_PLACED, configured.getOrThrow(ModConfiguredFeatures.CHILLBERRY), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, WILD_SUNFIRE_TOMATO_PLACED, configured.getOrThrow(ModConfiguredFeatures.WILD_SUNFIRE_TOMATO), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, WILD_MANDRAKE_PLACED, configured.getOrThrow(ModConfiguredFeatures.WILD_MANDRAKE), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, GHOST_FERN_PLACED, configured.getOrThrow(ModConfiguredFeatures.GHOST_FERN), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, CELESTIAL_BLOOM_PLACED, configured.getOrThrow(ModConfiguredFeatures.CELESTIAL_BLOOM), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, BEGONIA_PLACED, configured.getOrThrow(ModConfiguredFeatures.BEGONIA), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, LAVENDER_PLACED, configured.getOrThrow(ModConfiguredFeatures.LAVENDER), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, DAHLIA_PLACED, configured.getOrThrow(ModConfiguredFeatures.DAHLIA), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, PALE_MUSHROOM_PLACED, configured.getOrThrow(ModConfiguredFeatures.PALE_MUSHROOM), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, WITCHWEED_PLACED, configured.getOrThrow(ModConfiguredFeatures.WITCHWEED), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, NIGHTSHADE_BUSH_PLACED, configured.getOrThrow(ModConfiguredFeatures.NIGHTSHADE_BUSH), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, LOTUS_FLOWER_PLACED, configured.getOrThrow(ModConfiguredFeatures.LOTUS_FLOWER), ModPlacedFeatures.waterSurfacePatch(1));
        ModPlacedFeatures.register(context, COTTONWOOD_PLACED, configured.getOrThrow(ModConfiguredFeatures.COTTONWOOD), ModPlacedFeatures.rareTreePlacement((Block)ModBlocks.COTTONWOOD_SAPLING.get(), 25));
        ModPlacedFeatures.register(context, WILLOW_PLACED, configured.getOrThrow(ModConfiguredFeatures.WILLOW), ModPlacedFeatures.rareTreePlacement((Block)ModBlocks.WILLOW_SAPLING.get(), 25));
        ModPlacedFeatures.register(context, DARK_OAK_COCOON_PLACED, configured.getOrThrow(ModConfiguredFeatures.DARK_OAK_COCOON), ModPlacedFeatures.rareTreePlacement(Blocks.DARK_OAK_SAPLING, 25));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static List<PlacementModifier> rarityPatch(int rarity) {
        return List.of(RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
    }

    private static List<PlacementModifier> waterSurfacePatch(int count) {
        return List.of(CountPlacement.of((int)count), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
    }

    private static List<PlacementModifier> rareTreePlacement(Block sapling, int rarity) {
        return List.of(RarityFilter.onAverageOnceEvery((int)rarity), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)sapling.defaultBlockState(), (Vec3i)BlockPos.ZERO)));
    }
}

