/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class Configuration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final Path COMMON_PATH = CONFIG_DIR.resolve("hexalia-common.json");
    private static final Path CLIENT_PATH = CONFIG_DIR.resolve("hexalia-client.json");
    private static Common COMMON;
    private static Client CLIENT;

    private Configuration() {
    }

    public static Common common() {
        if (COMMON == null) {
            Configuration.loadCommon();
        }
        return COMMON;
    }

    public static Client client() {
        if (CLIENT == null) {
            Configuration.loadClient();
        }
        return CLIENT;
    }

    public static void saveAll() {
        Configuration.saveCommon();
        Configuration.saveClient();
    }

    public static void loadCommon() {
        Configuration.ensureDir();
        try {
            if (Files.exists(COMMON_PATH, new LinkOption[0])) {
                COMMON = (Common)GSON.fromJson(Files.readString(COMMON_PATH), Common.class);
                if (COMMON == null) {
                    COMMON = new Common();
                }
            } else {
                COMMON = new Common();
                Configuration.saveCommon();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            COMMON = new Common();
        }
        COMMON.validate();
    }

    public static void saveCommon() {
        Configuration.ensureDir();
        try {
            Files.writeString(COMMON_PATH, (CharSequence)GSON.toJson((Object)(COMMON == null ? new Common() : COMMON)), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadClient() {
        Configuration.ensureDir();
        try {
            if (Files.exists(CLIENT_PATH, new LinkOption[0])) {
                CLIENT = (Client)GSON.fromJson(Files.readString(CLIENT_PATH), Client.class);
                if (CLIENT == null) {
                    CLIENT = new Client();
                }
            } else {
                CLIENT = new Client();
                Configuration.saveClient();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            CLIENT = new Client();
        }
        CLIENT.validate();
    }

    public static void saveClient() {
        Configuration.ensureDir();
        try {
            Files.writeString(CLIENT_PATH, (CharSequence)GSON.toJson((Object)(CLIENT == null ? new Client() : CLIENT)), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void ensureDir() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int clamp(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }

    private static double clamp(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }

    public static final class Common {
        public FunctionalBlocks functional_blocks = new FunctionalBlocks();
        public Tools tools = new Tools();
        public Plants plants = new Plants();

        public void validate() {
            this.functional_blocks.validate();
            this.tools.validate();
            this.plants.validate();
        }

        public static final class FunctionalBlocks {
            public int censerEffectRadius = 16;
            public int censerEffectDuration = 7200;
            public int dreamcatcherRadius = 16;
            public int phantomIgniteDuration = 100;

            void validate() {
                this.censerEffectRadius = Configuration.clamp(this.censerEffectRadius, 1, 64);
                this.censerEffectDuration = Configuration.clamp(this.censerEffectDuration, 20, 24000);
                this.dreamcatcherRadius = Configuration.clamp(this.dreamcatcherRadius, 1, 64);
                this.phantomIgniteDuration = Configuration.clamp(this.phantomIgniteDuration, 0, 600);
            }
        }

        public static final class Tools {
            public double mandrakeScreamRadius = 5.0;
            public int mandrakeStunDuration = 3;
            public int foulSacDuration = 8;
            public int frostSacDuration = 8;
            public int purifyingSacDuration = 8;
            public double siphonRadius = 5.0;
            public double bleedingDamage = 0.5;

            void validate() {
                this.mandrakeScreamRadius = Configuration.clamp(this.mandrakeScreamRadius, 1.0, 32.0);
                this.mandrakeStunDuration = Configuration.clamp(this.mandrakeStunDuration, 1, 60);
                this.foulSacDuration = Configuration.clamp(this.foulSacDuration, 1, 60);
                this.frostSacDuration = Configuration.clamp(this.frostSacDuration, 1, 60);
                this.purifyingSacDuration = Configuration.clamp(this.purifyingSacDuration, 1, 60);
                this.siphonRadius = Configuration.clamp(this.siphonRadius, 0.5, 64.0);
                this.bleedingDamage = Configuration.clamp(this.bleedingDamage, 0.0, 10.0);
            }
        }

        public static final class Plants {
            public int nautiliteDuration = 2400;
            public int nautiliteEffectRadius = 16;
            public int windsongDuration = 600;
            public int windsongEffectRadius = 6;
            public int astrylisDuration = 1200;
            public int astrylisBonemealInterval = 240;
            public int morphoraEffectRadius = 6;
            public int grimshadeDuration = 2400;
            public int grimshadeEffectRadius = 16;

            void validate() {
                this.nautiliteDuration = Configuration.clamp(this.nautiliteDuration, 100, 24000);
                this.nautiliteEffectRadius = Configuration.clamp(this.nautiliteEffectRadius, 1, 64);
                this.windsongDuration = Configuration.clamp(this.windsongDuration, 100, 24000);
                this.windsongEffectRadius = Configuration.clamp(this.windsongEffectRadius, 1, 32);
                this.astrylisDuration = Configuration.clamp(this.astrylisDuration, 100, 24000);
                this.astrylisBonemealInterval = Configuration.clamp(this.astrylisBonemealInterval, 20, 1200);
                this.morphoraEffectRadius = Configuration.clamp(this.morphoraEffectRadius, 1, 32);
                this.grimshadeDuration = Configuration.clamp(this.grimshadeDuration, 100, 24000);
                this.grimshadeEffectRadius = Configuration.clamp(this.grimshadeEffectRadius, 1, 64);
            }
        }
    }

    public static final class Client {
        public ClientPlants plants = new ClientPlants();

        public void validate() {
        }

        public static final class ClientPlants {
            public boolean ghostFernEmitsParticles = true;
            public boolean celestialBloomEmitsParticles = true;
        }
    }
}

