/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom.censer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.stream.StreamSupport;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.CenserBlock;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.custom.CenserBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5354;

public class CenserEffectHandler {
    private static final Map<class_1937, Set<class_2338>> UNDEAD_VEIL_CACHE = new WeakHashMap<class_1937, Set<class_2338>>();
    private static final int MINERS_RESPITE_EFFECT_REFRESH_TICKS = 300;
    public static final Map<HerbCombination, BiConsumer<class_1937, class_2338>> EFFECTS = Map.of(new HerbCombination(ModItems.SIREN_KELP, ModBlocks.SPIRIT_BLOOM.method_8389()), CenserEffectHandler::applyFireproofPresence, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), CenserEffectHandler::applyUndeadVeil, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModItems.SIREN_KELP), CenserEffectHandler::applyLivestockComfort, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), CenserEffectHandler::applyMinersRespite, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModItems.SIREN_KELP), CenserEffectHandler::applyFishersBoon, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.GHOST_FERN.method_8389()), CenserEffectHandler::applySuctionZone);
    private static final Map<HerbCombination, EffectType> COMBO_TO_EFFECT = Map.of(new HerbCombination(ModItems.SIREN_KELP, ModBlocks.SPIRIT_BLOOM.method_8389()), EffectType.FIREPROOF_PRESENCE, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), EffectType.UNDEAD_VEIL, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModItems.SIREN_KELP), EffectType.LIVESTOCK_COMFORT, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), EffectType.MINERS_RESPITE, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModItems.SIREN_KELP), EffectType.FISHERS_BOON, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.GHOST_FERN.method_8389()), EffectType.SUCTION_ZONE);
    private static final Map<class_2338, ActiveCenserEffect> ACTIVE_EFFECTS = new HashMap<class_2338, ActiveCenserEffect>();

    public static void registerActiveEffect(class_1937 world, class_2338 pos, HerbCombination combo, int remainingTime) {
        if (world.method_8608()) {
            return;
        }
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, remainingTime, combo));
        CenserEffectHandler.applyEffects(world, pos, combo);
        if (CenserEffectHandler.getEffectTypeForCombination(combo) == EffectType.UNDEAD_VEIL) {
            UNDEAD_VEIL_CACHE.computeIfAbsent(world, k -> new HashSet()).add(pos.method_10062());
        }
    }

    public static void removeActiveEffect(class_2338 pos) {
        EffectType effectType;
        ActiveCenserEffect effect = ACTIVE_EFFECTS.get(pos);
        if (effect != null && (effectType = CenserEffectHandler.getEffectTypeForCombination(effect.combo())) == EffectType.UNDEAD_VEIL) {
            for (Map.Entry<class_1937, Set<class_2338>> entry : UNDEAD_VEIL_CACHE.entrySet()) {
                if (entry.getValue().remove(pos)) break;
            }
        }
        ACTIVE_EFFECTS.remove(pos);
    }

    public static void startEffect(class_1937 world, class_2338 pos, HerbCombination combo) {
        if (world.method_8608()) {
            return;
        }
        int duration = Configuration.common().functional_blocks.censerEffectDuration;
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, duration, combo));
        CenserEffectHandler.applyEffects(world, pos, combo);
        class_2586 be = world.method_8321(pos);
        if (be instanceof CenserBlockEntity) {
            CenserBlockEntity censer = (CenserBlockEntity)be;
            censer.setActiveCombination(combo);
            censer.setBurnTime(duration);
        }
        if (CenserEffectHandler.getEffectTypeForCombination(combo) == EffectType.MINERS_RESPITE && world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            CenserEffectHandler.repairAnvilsInArea(sw, pos, Configuration.common().functional_blocks.censerEffectRadius);
        }
    }

    public static void updateEffects(class_1937 world) {
        Iterator<Map.Entry<class_2338, ActiveCenserEffect>> it = ACTIVE_EFFECTS.entrySet().iterator();
        while (it.hasNext()) {
            CenserBlockEntity censer;
            boolean aliveAndLit;
            Map.Entry<class_2338, ActiveCenserEffect> entry = it.next();
            class_2338 pos = entry.getKey();
            ActiveCenserEffect effect = entry.getValue();
            class_2586 be = world.method_8321(pos);
            boolean bl = aliveAndLit = be instanceof CenserBlockEntity && (Boolean)(censer = (CenserBlockEntity)be).method_11010().method_11654((class_2769)CenserBlock.LIT) != false;
            if (!aliveAndLit) {
                CenserEffectHandler.clearEffect(world, pos, effect.combo());
                it.remove();
                continue;
            }
            effect.decrementDuration();
            if (effect.isExpired()) {
                CenserEffectHandler.clearEffect(world, pos, effect.combo());
                it.remove();
                continue;
            }
            CenserEffectHandler.applyEffects(world, pos, effect.combo());
        }
    }

    public static void applyEffects(class_1937 world, class_2338 pos, HerbCombination combo) {
        if (world.method_8608()) {
            return;
        }
        EFFECTS.getOrDefault(combo, (w, p) -> {}).accept(world, pos);
    }

    public static boolean isValidCombination(class_1792 item1, class_1792 item2) {
        HerbCombination combo = new HerbCombination(item1, item2);
        return EFFECTS.containsKey(combo);
    }

    public static void clearPlayerEffectsInRange(class_1937 world, class_2338 pos) {
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        class_238 area = new class_238(pos).method_1014((double)radius);
        for (class_1657 player : world.method_8390(class_1657.class, area, p -> true)) {
            player.method_5738("hexalia:fishers_boon");
        }
    }

    public static boolean isUndeadVeilActiveInArea(class_1937 world, class_2338 pos) {
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        if (world.method_8608()) {
            return false;
        }
        Set<class_2338> veilPositions = UNDEAD_VEIL_CACHE.get(world);
        if (veilPositions == null || veilPositions.isEmpty()) {
            return false;
        }
        double r2 = radius * radius;
        for (class_2338 center : veilPositions) {
            if (!(pos.method_10262((class_2382)center) <= r2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEffectActiveInArea(class_1937 world, class_2338 pos, EffectType effectType) {
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        if (effectType == EffectType.UNDEAD_VEIL) {
            return CenserEffectHandler.isUndeadVeilActiveInArea(world, pos);
        }
        class_238 area = new class_238(pos).method_1014((double)radius);
        return StreamSupport.stream(class_2338.method_10097((class_2338)new class_2338((int)Math.floor(area.field_1323), (int)Math.floor(area.field_1322), (int)Math.floor(area.field_1321)), (class_2338)new class_2338((int)Math.floor(area.field_1320), (int)Math.floor(area.field_1325), (int)Math.floor(area.field_1324))).spliterator(), false).map(arg_0 -> ((class_1937)world).method_8321(arg_0)).filter(be -> be instanceof CenserBlockEntity).map(be -> (CenserBlockEntity)((Object)be)).anyMatch(censer -> {
            if (!((Boolean)censer.method_11010().method_11654((class_2769)CenserBlock.LIT)).booleanValue()) {
                return false;
            }
            class_1799 herb1 = censer.getItem(0);
            class_1799 herb2 = censer.getItem(1);
            if (herb1.method_7960() || herb2.method_7960()) {
                return false;
            }
            return CenserEffectHandler.getEffectTypeForCombination(new HerbCombination(herb1.method_7909(), herb2.method_7909())) == effectType;
        });
    }

    public static String getMessageKeyForCombination(HerbCombination combo) {
        if (combo.equals(new HerbCombination(ModItems.SIREN_KELP, ModBlocks.SPIRIT_BLOOM.method_8389()))) {
            return "message.hexalia.censer.fireproof_presence";
        }
        if (combo.equals(new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()))) {
            return "message.hexalia.censer.undead_veil";
        }
        if (combo.equals(new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModItems.SIREN_KELP))) {
            return "message.hexalia.censer.livestock_comfort";
        }
        if (combo.equals(new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()))) {
            return "message.hexalia.censer.miners_respite";
        }
        if (combo.equals(new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModItems.SIREN_KELP))) {
            return "message.hexalia.censer.fishers_boon";
        }
        if (combo.equals(new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.GHOST_FERN.method_8389()))) {
            return "message.hexalia.censer.suction_zone";
        }
        return "message.hexalia.censer.generic_effect";
    }

    private static void clearEffect(class_1937 world, class_2338 pos, HerbCombination combo) {
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        class_238 area = new class_238(pos).method_1014((double)radius);
        for (class_1657 player : world.method_8390(class_1657.class, area, p -> true)) {
            player.method_5738("hexalia:fishers_boon");
        }
    }

    private static void applyFireproofPresence(class_1937 world, class_2338 pos) {
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        class_238 area = new class_238(pos).method_1014((double)radius);
        for (class_1309 entity : world.method_8390(class_1309.class, area, e -> true)) {
            entity.method_33572(false);
            entity.method_20803(0);
            entity.method_6092(new class_1293(class_1294.field_5918, 100, 0, false, false, true));
        }
    }

    private static void applyUndeadVeil(class_1937 world, class_2338 pos) {
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        class_238 area = new class_238(pos).method_1014((double)radius);
        for (class_1588 mob : world.method_8390(class_1588.class, area, e -> true)) {
            mob.method_5980(null);
            mob.method_6015(null);
            if (mob instanceof class_5354) {
                class_5354 angerable = (class_5354)mob;
                angerable.method_29513(null);
                angerable.method_29514(0);
            }
            if (mob.method_6059(class_1294.field_5912)) continue;
            mob.method_6092(new class_1293(class_1294.field_5912, 140, 0, false, false));
        }
    }

    private static void applyLivestockComfort(class_1937 world, class_2338 pos) {
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        class_238 area = new class_238(pos).method_1014((double)radius);
        for (class_1429 animal : world.method_8390(class_1429.class, area, a -> true)) {
            if (animal.method_5618() >= 0) continue;
            int newAge = (int)((double)animal.method_5618() * 0.5);
            animal.method_5614(newAge);
        }
    }

    private static void applyMinersRespite(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        class_238 area = new class_238(pos).method_1014((double)radius);
        for (class_1657 player : serverWorld.method_8390(class_1657.class, area, p -> true)) {
            player.method_6092(new class_1293(class_1294.field_5925, 300, 0, false, false, true));
            player.method_6092(new class_1293(class_1294.field_5917, 300, 1, false, false, true));
        }
    }

    private static void repairAnvilsInArea(class_3218 world, class_2338 center, int radius) {
        class_238 area = new class_238(center).method_1014((double)radius);
        class_2338 min = class_2338.method_49637((double)area.field_1323, (double)area.field_1322, (double)area.field_1321);
        class_2338 max = class_2338.method_49637((double)area.field_1320, (double)area.field_1325, (double)area.field_1324);
        for (class_2338 bp : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            class_2680 state = world.method_8320(bp);
            if (!(state.method_26204() instanceof class_2199)) continue;
            class_2350 facing = state.method_28498((class_2769)class_2199.field_9883) ? (class_2350)state.method_11654((class_2769)class_2199.field_9883) : class_2350.field_11043;
            class_2680 repaired = null;
            if (state.method_27852(class_2246.field_10414)) {
                repaired = class_2246.field_10105.method_9564();
            } else if (state.method_27852(class_2246.field_10105)) {
                repaired = class_2246.field_10535.method_9564();
            }
            if (repaired == null) continue;
            if (repaired.method_28498((class_2769)class_2199.field_9883)) {
                repaired = (class_2680)repaired.method_11657((class_2769)class_2199.field_9883, (Comparable)facing);
            }
            world.method_8652(bp, repaired, 3);
            world.method_8396(null, bp, class_3417.field_14559, class_3419.field_15245, 0.35f, 1.2f);
            world.method_14199((class_2394)class_2398.field_11211, (double)bp.method_10263() + 0.5, (double)bp.method_10264() + 1.0, (double)bp.method_10260() + 0.5, 3, 0.25, 0.15, 0.25, 0.0);
        }
    }

    private static void applyFishersBoon(class_1937 world, class_2338 pos) {
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        class_238 area = new class_238(pos).method_1014((double)radius);
        for (class_1657 player : world.method_8390(class_1657.class, area, p -> true)) {
            player.method_5780("hexalia:fishers_boon");
        }
    }

    private static void applySuctionZone(class_1937 world, class_2338 pos) {
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_238 area = new class_238(pos).method_1014((double)radius);
        List items = serverWorld.method_8390(class_1542.class, area, e -> true);
        if (items.isEmpty()) {
            return;
        }
        List<class_2614> hoppers = StreamSupport.stream(class_2338.method_10097((class_2338)new class_2338((int)Math.floor(area.field_1323), (int)Math.floor(area.field_1322), (int)Math.floor(area.field_1321)), (class_2338)new class_2338((int)Math.floor(area.field_1320), (int)Math.floor(area.field_1325), (int)Math.floor(area.field_1324))).spliterator(), false).map(arg_0 -> ((class_3218)serverWorld).method_8321(arg_0)).filter(be -> be instanceof class_2614).map(be -> (class_2614)be).toList();
        for (class_1542 item : items) {
            if (!item.method_5805()) continue;
            class_243 itemPos = item.method_19538();
            boolean itemAbsorbed = false;
            if (!hoppers.isEmpty()) {
                for (class_2614 hopper : hoppers) {
                    class_2614 inv = hopper;
                    class_1799 remaining = CenserEffectHandler.tryInsert((class_1263)inv, item.method_6983().method_7972());
                    if (remaining.method_7960()) {
                        itemAbsorbed = true;
                        break;
                    }
                    if (remaining.method_7947() >= item.method_6983().method_7947()) continue;
                    item.method_6979(remaining);
                    CenserEffectHandler.playSuctionEffects(serverWorld, itemPos);
                }
            } else {
                class_1657 nearestPlayer = (class_1657)CenserEffectHandler.findNearestEntity(itemPos, serverWorld.method_8390(class_1657.class, area, p -> true));
                if (nearestPlayer != null) {
                    item.method_5694(nearestPlayer);
                }
            }
            if (!itemAbsorbed) continue;
            CenserEffectHandler.playSuctionEffects(serverWorld, itemPos);
            item.method_31472();
        }
    }

    private static class_1799 tryInsert(class_1263 inv, class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        for (int i = 0; i < inv.method_5439() && !stack.method_7960(); ++i) {
            int max;
            int space;
            class_1799 slot = inv.method_5438(i);
            if (slot.method_7960()) {
                inv.method_5447(i, stack);
                inv.method_5431();
                return class_1799.field_8037;
            }
            if (!CenserEffectHandler.stacksCanCombine(slot, stack) || (space = (max = Math.min(inv.method_5444(), slot.method_7914())) - slot.method_7947()) <= 0) continue;
            int move = Math.min(space, stack.method_7947());
            slot.method_7933(move);
            stack.method_7934(move);
            inv.method_5431();
        }
        return stack;
    }

    private static void playSuctionEffects(class_3218 world, class_243 pos) {
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, (class_3414)class_3417.field_49049.comp_349(), class_3419.field_15245, 0.7f, 0.9f + world.field_9229.method_43057() * 0.2f);
        for (int i = 0; i < 8; ++i) {
            double angle = world.field_9229.method_43058() * Math.PI * 2.0;
            double r = world.field_9229.method_43058() * 0.5;
            double x = pos.field_1352 + r * Math.cos(angle);
            double z = pos.field_1350 + r * Math.sin(angle);
            double y = pos.field_1351 + world.field_9229.method_43058() * 0.5;
            world.method_14199((class_2394)class_2398.field_11245, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static <T extends class_1297> T findNearestEntity(class_243 position, List<T> entities) {
        class_1297 nearest = null;
        double closest = Double.MAX_VALUE;
        for (class_1297 e : entities) {
            double d = position.method_1025(e.method_19538());
            if (!(d < closest)) continue;
            closest = d;
            nearest = e;
        }
        return (T)nearest;
    }

    private static EffectType getEffectTypeForCombination(HerbCombination combo) {
        return COMBO_TO_EFFECT.getOrDefault(combo, null);
    }

    private static boolean stacksCanCombine(class_1799 a, class_1799 b) {
        return class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    private static class ActiveCenserEffect {
        private final EffectType type;
        private int duration;
        private final HerbCombination combo;

        public ActiveCenserEffect(EffectType type, int duration, HerbCombination combo) {
            this.type = type;
            this.duration = duration;
            this.combo = combo;
        }

        public void decrementDuration() {
            --this.duration;
        }

        public boolean isExpired() {
            return this.duration <= 0;
        }

        public HerbCombination combo() {
            return this.combo;
        }
    }

    public static enum EffectType {
        FIREPROOF_PRESENCE,
        UNDEAD_VEIL,
        LIVESTOCK_COMFORT,
        MINERS_RESPITE,
        FISHERS_BOON,
        SUCTION_ZONE;

    }
}

