/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.List;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class GrimshadeBlockEntity
extends class_2586 {
    private int activeTicks = 0;
    private long activationTime = -1L;

    public GrimshadeBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.GRIMSHADE, pos, state);
    }

    private static int duration() {
        int v = Configuration.common().plants.grimshadeDuration;
        return Math.max(1, v <= 0 ? 2400 : v);
    }

    private static int effectRadius() {
        int v = Configuration.common().plants.grimshadeEffectRadius;
        return Math.max(1, v <= 0 ? 8 : v);
    }

    public void activate() {
        this.activeTicks = GrimshadeBlockEntity.duration();
        if (this.field_11863 != null) {
            this.activationTime = this.field_11863.method_8510();
        }
        this.method_5431();
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, GrimshadeBlockEntity be) {
        if (be.activationTime != -1L && world != null) {
            long now = world.method_8510();
            long elapsed = now - be.activationTime;
            int expected = GrimshadeBlockEntity.duration() - (int)elapsed;
            if (Math.abs(be.activeTicks - expected) > 5) {
                be.activeTicks = Math.max(0, expected);
            }
        }
        if (!be.isActive()) {
            return;
        }
        --be.activeTicks;
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            if (server.method_8407() != class_1267.field_5801) {
                int r = GrimshadeBlockEntity.effectRadius();
                class_238 area = new class_238(pos).method_1014((double)r);
                List targets = server.method_8390(class_1309.class, area, e -> e.method_5805() && !(e instanceof class_1657));
                for (class_1309 mob : targets) {
                    mob.method_6092(new class_1293(class_1294.field_5920, 60, 0, true, true));
                    mob.method_6092(new class_1293(class_1294.field_5911, 60, 0, true, true));
                }
            }
            GrimshadeBlockEntity.emitParticles(server, pos);
        }
        if (be.activeTicks <= 0) {
            world.method_8396(null, pos, class_3417.field_38060, class_3419.field_15245, 0.6f, 0.7f);
            be.method_5431();
        } else {
            be.method_5431();
        }
    }

    public void applyCollisionPing(class_1309 e) {
        if (this.field_11863 == null || this.field_11863.field_9236 || this.field_11863.method_8407() == class_1267.field_5801) {
            return;
        }
        if (e instanceof class_1657) {
            return;
        }
        e.method_6092(new class_1293(class_1294.field_5920, 60, 0, true, true));
        e.method_6092(new class_1293(class_1294.field_5911, 60, 0, true, true));
    }

    private static void emitParticles(class_3218 world, class_2338 pos) {
        if (world.method_8409().method_43048(3) != 0) {
            return;
        }
        class_243 c = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.6, (double)pos.method_10260() + 0.5);
        class_5819 rand = world.method_8409();
        int count = 6 + rand.method_43048(4);
        for (int i = 0; i < count; ++i) {
            double ox = (rand.method_43058() - 0.5) * 0.6;
            double oy = rand.method_43058() * 0.5;
            double oz = (rand.method_43058() - 0.5) * 0.6;
            world.method_14199((class_2394)class_2398.field_11251, c.field_1352 + ox, c.field_1351 + oy, c.field_1350 + oz, 1, 0.0, 0.001, 0.0, 0.0);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.activeTicks = nbt.method_10550("ActiveTicks");
        this.activationTime = nbt.method_10537("ActivationTime");
        if (this.activationTime != -1L && this.field_11863 != null && this.activeTicks > 0) {
            long now = this.field_11863.method_8510();
            long elapsed = now - this.activationTime;
            this.activeTicks = Math.max(0, GrimshadeBlockEntity.duration() - (int)elapsed);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("ActiveTicks", this.activeTicks);
        nbt.method_10544("ActivationTime", this.activationTime);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = super.method_16887(registryLookup);
        nbt.method_10569("ActiveTicks", this.activeTicks);
        nbt.method_10544("ActivationTime", this.activationTime);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

