/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.RitualBrazierBlockEntity;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;

public class RitualTableBlockEntity
extends SyncBlockEntity
implements class_1263 {
    public static final int DURATION = 160;
    private final class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private class_1799 cachedParticleItem = class_1799.field_8037;
    private List<RitualBrazierBlockEntity> activeBraziers = Collections.emptyList();
    private List<class_2338> grownCrops = Collections.emptyList();
    private class_1799 pendingOutput = class_1799.field_8037;
    private int transformTicksRemaining = 0;
    private int totalTransformTicks = 0;
    private int nextBrazierIndex = 0;
    private float rotation = 0.0f;

    public RitualTableBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.RITUAL_TABLE, pos, state);
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return ((class_1799)this.items.get(0)).method_7960();
    }

    public class_1799 method_5438(int slot) {
        return slot == 0 ? (class_1799)this.items.get(0) : class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 out = class_1262.method_5430(this.items, (int)slot, (int)amount);
        if (!out.method_7960()) {
            this.inventoryChanged();
        }
        return out;
    }

    public class_1799 method_5441(int slot) {
        class_1799 out = class_1262.method_5428(this.items, (int)slot);
        if (!out.method_7960()) {
            this.inventoryChanged();
        }
        return out;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot != 0) {
            return;
        }
        if (stack.method_31574(ModItems.HEX_FOCUS)) {
            return;
        }
        this.items.set(0, (Object)(stack.method_7960() ? class_1799.field_8037 : stack.method_46651(1)));
        this.inventoryChanged();
    }

    public void method_5431() {
        super.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        double cz;
        double cy;
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        double cx = (double)this.field_11867.method_10263() + 0.5;
        return player.method_5649(cx, cy = (double)this.field_11867.method_10264() + 0.5, cz = (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.items.set(0, (Object)class_1799.field_8037);
        this.inventoryChanged();
    }

    public float getRenderingRotation() {
        this.rotation = (this.rotation + 0.5f) % 360.0f;
        return this.rotation;
    }

    public void startTransformation(class_1799 output, int durationTicks, List<RitualBrazierBlockEntity> braziers) {
        if (this.transformTicksRemaining > 0) {
            return;
        }
        this.transformTicksRemaining = durationTicks;
        this.totalTransformTicks = durationTicks;
        this.pendingOutput = output.method_7972();
        this.activeBraziers = new ArrayList<RitualBrazierBlockEntity>(braziers);
        this.nextBrazierIndex = 0;
        this.method_5431();
    }

    public void setGrownCropPositions(List<class_2338> crops) {
        this.grownCrops = new ArrayList<class_2338>(crops);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, RitualTableBlockEntity be) {
        if (be.transformTicksRemaining <= 0) {
            return;
        }
        if (be.method_5442() || RitualTableBlockEntity.hasMissingBrazierItems(be)) {
            RitualTableBlockEntity.cancelRitual(world, pos, be);
            return;
        }
        int base = be.totalTransformTicks > 0 ? be.totalTransformTicks : 160;
        int elapsed = base - be.transformTicksRemaining;
        RitualTableBlockEntity.handleActiveBraziers(world, pos, be, elapsed);
        --be.transformTicksRemaining;
        if (be.transformTicksRemaining == 0) {
            RitualTableBlockEntity.completeRitual(world, pos, be);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        nbt.method_10569("TicksLeft", this.transformTicksRemaining);
        nbt.method_10569("TotalTicks", this.totalTransformTicks);
        if (!this.pendingOutput.method_7960()) {
            class_2487 out = new class_2487();
            this.pendingOutput.method_57376(lookup, (class_2520)out);
            nbt.method_10566("PendingOut", (class_2520)out);
        }
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        this.transformTicksRemaining = nbt.method_10550("TicksLeft");
        this.totalTransformTicks = nbt.method_10550("TotalTicks");
        this.pendingOutput = nbt.method_10573("PendingOut", 10) ? class_1799.method_57360((class_7225.class_7874)lookup, (class_2520)nbt.method_10562("PendingOut")).orElse(class_1799.field_8037) : class_1799.field_8037;
        this.items.set(0, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)lookup);
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 lookup) {
        return this.method_38244(lookup);
    }

    public boolean addItem(class_1799 fromPlayer) {
        if (this.method_5442() && !fromPlayer.method_7960() && !fromPlayer.method_31574(ModItems.HEX_FOCUS)) {
            class_1799 one = fromPlayer.method_7972();
            one.method_7939(1);
            this.method_5447(0, one);
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        if (this.method_5442()) {
            return class_1799.field_8037;
        }
        class_1799 out = this.method_5438(0);
        this.method_5447(0, class_1799.field_8037);
        return out;
    }

    public class_1799 getStoredItem() {
        return this.method_5438(0);
    }

    @Override
    protected void inventoryChanged() {
        if (this.field_11863 == null) {
            return;
        }
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
        }
    }

    private static boolean hasMissingBrazierItems(RitualTableBlockEntity be) {
        for (int i = be.nextBrazierIndex; i < be.activeBraziers.size(); ++i) {
            RitualBrazierBlockEntity brazier = be.activeBraziers.get(i);
            if (i == be.nextBrazierIndex && !be.cachedParticleItem.method_7960() || !brazier.method_5442()) continue;
            return true;
        }
        return false;
    }

    private static void handleActiveBraziers(class_1937 world, class_2338 pos, RitualTableBlockEntity be, int elapsed) {
        class_3218 server;
        if (be.activeBraziers.isEmpty() || be.nextBrazierIndex >= be.activeBraziers.size()) {
            return;
        }
        int ticksPerBrazier = 40;
        int currentTime = elapsed - be.nextBrazierIndex * ticksPerBrazier;
        RitualBrazierBlockEntity brazier = be.activeBraziers.get(be.nextBrazierIndex);
        if (currentTime == 0) {
            be.cachedParticleItem = brazier.getStoredItem().method_7972();
            brazier.removeItem();
        }
        if (currentTime >= 0 && currentTime < ticksPerBrazier && world instanceof class_3218) {
            server = (class_3218)world;
            RitualTableBlockEntity.spawnItemParticles(server, be.cachedParticleItem, brazier.method_11016(), pos, currentTime, ticksPerBrazier);
        }
        if (currentTime == ticksPerBrazier - 1) {
            if (world instanceof class_3218) {
                server = (class_3218)world;
                RitualTableBlockEntity.spawnAbsorbBurst(server, pos, be.cachedParticleItem);
            }
            ++be.nextBrazierIndex;
            be.cachedParticleItem = class_1799.field_8037;
        }
    }

    private static void spawnItemParticles(class_3218 server, class_1799 item, class_2338 from, class_2338 to, int time, int totalTime) {
        if (item.method_7960()) {
            return;
        }
        class_2392 particle = new class_2392(class_2398.field_11218, item);
        double startX = (double)from.method_10263() + 0.5;
        double startY = (double)from.method_10264() + 0.4;
        double startZ = (double)from.method_10260() + 0.5;
        double endX = (double)to.method_10263() + 0.5;
        double endY = (double)to.method_10264() + 1.15;
        double endZ = (double)to.method_10260() + 0.5;
        double progress = (double)time / (double)totalTime;
        double px = startX + (endX - startX) * progress;
        double py = startY + (endY - startY) * progress;
        double pz = startZ + (endZ - startZ) * progress;
        for (int i = 0; i < 3; ++i) {
            double offsetX = (server.field_9229.method_43058() - 0.5) * 0.05;
            double offsetY = (server.field_9229.method_43058() - 0.5) * 0.05;
            double offsetZ = (server.field_9229.method_43058() - 0.5) * 0.05;
            double speed = 0.008 + server.field_9229.method_43058() * 0.004;
            double velX = (endX - startX) * speed;
            double velY = (endY - startY) * speed + 0.003;
            double velZ = (endZ - startZ) * speed;
            server.method_14199((class_2394)particle, px + offsetX, py + offsetY, pz + offsetZ, 1, velX, velY, velZ, 0.0);
        }
    }

    private static void spawnAbsorbBurst(class_3218 server, class_2338 pos, class_1799 item) {
        double vz;
        double vy;
        double vx;
        double dz;
        double dy;
        double dx;
        int i;
        double cx = (double)pos.method_10263() + 0.5;
        double cy = (double)pos.method_10264() + 1.1;
        double cz = (double)pos.method_10260() + 0.5;
        for (i = 0; i < 12; ++i) {
            dx = (server.field_9229.method_43058() - 0.5) * 0.5;
            dy = server.field_9229.method_43058() * 0.3;
            dz = (server.field_9229.method_43058() - 0.5) * 0.5;
            vx = (server.field_9229.method_43058() - 0.5) * 0.02;
            vy = 0.04 + server.field_9229.method_43058() * 0.02;
            vz = (server.field_9229.method_43058() - 0.5) * 0.02;
            server.method_14199((class_2394)class_2398.field_11249, cx + dx, cy + dy, cz + dz, 1, vx, vy, vz, 0.0);
        }
        if (!item.method_7960()) {
            for (i = 0; i < 8; ++i) {
                dx = (server.field_9229.method_43058() - 0.5) * 0.2;
                dy = server.field_9229.method_43058() * 0.2;
                dz = (server.field_9229.method_43058() - 0.5) * 0.2;
                vx = (server.field_9229.method_43058() - 0.5) * 0.005;
                vy = 0.015 + server.field_9229.method_43058() * 0.005;
                vz = (server.field_9229.method_43058() - 0.5) * 0.005;
                server.method_14199((class_2394)new class_2392(class_2398.field_11218, item), cx + dx, cy + dy, cz + dz, 1, vx, vy, vz, 0.0);
            }
        }
        server.method_8396(null, pos, class_3417.field_15119, class_3419.field_15245, 0.4f, 1.2f + server.field_9229.method_43057() * 0.2f);
    }

    private static void completeRitual(class_1937 world, class_2338 pos, RitualTableBlockEntity be) {
        be.method_5447(0, be.pendingOutput);
        be.pendingOutput = class_1799.field_8037;
        for (class_2338 cropPos : be.grownCrops) {
            class_2680 st = world.method_8320(cropPos);
            class_2248 class_22482 = st.method_26204();
            if (!(class_22482 instanceof class_2302)) continue;
            class_2302 crop = (class_2302)class_22482;
            if (!st.method_28498((class_2769)class_2302.field_10835)) continue;
            world.method_8652(cropPos, (class_2680)st.method_11657((class_2769)class_2302.field_10835, (Comparable)Integer.valueOf(0)), 3);
        }
        be.activeBraziers = Collections.emptyList();
        be.nextBrazierIndex = 0;
        world.method_8396(null, pos, ModSoundEvents.RITUAL_SUCCESS, class_3419.field_15245, 0.8f, 1.0f);
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            server.method_14199((class_2394)ModParticleType.LEAVES, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 15, 0.3, 0.3, 0.3, 0.0);
        }
        be.method_5431();
    }

    private static void cancelRitual(class_1937 world, class_2338 pos, RitualTableBlockEntity be) {
        be.transformTicksRemaining = 0;
        be.totalTransformTicks = 0;
        be.pendingOutput = class_1799.field_8037;
        be.activeBraziers = Collections.emptyList();
        be.nextBrazierIndex = 0;
        be.cachedParticleItem = class_1799.field_8037;
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            server.method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 12, 0.4, 0.4, 0.4, 0.02);
            class_1657 nearest = server.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 5.0, false);
            if (nearest != null) {
                nearest.method_7353((class_2561)class_2561.method_43471((String)"message.hexalia.ritual.stopped_ritual"), true);
            }
        }
        world.method_8396(null, pos, class_3417.field_26955, class_3419.field_15245, 0.4f, 0.6f);
        be.method_5431();
    }
}

