/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3532;

public final class SunlightCheck {
    private final class_1937 world;
    private class_2338 pos;
    private final boolean needsRainCheck;
    private final float peakMultiplier;
    private boolean canSeeSun;

    public SunlightCheck(class_1937 world, class_2338 pos) {
        this.world = world;
        this.pos = pos;
        class_1959 biome = (class_1959)this.world.method_23753(this.pos).comp_349();
        this.needsRainCheck = biome.method_48162(this.pos) != class_1959.class_1963.field_9384;
        float tempEff = 0.3f * (0.8f - biome.method_8712());
        float humidity = SunlightCheck.resolveDownfall(biome);
        float humidityEff = this.needsRainCheck ? -0.3f * humidity : 0.0f;
        this.peakMultiplier = 1.0f + tempEff + humidityEff;
    }

    public void moveTo(class_2338 newPos) {
        this.pos = newPos;
        this.recheckCanSeeSun();
    }

    public void recheckCanSeeSun() {
        this.canSeeSun = SunlightCheck.canSeeSun(this.world, this.pos);
    }

    public boolean canSeeSunNow() {
        return this.canSeeSun;
    }

    public float getPeakMultiplier() {
        return this.peakMultiplier;
    }

    public float getGenerationMultiplier() {
        if (!this.canSeeSun) {
            return 0.0f;
        }
        if (this.needsRainCheck && (this.world.method_8419() || this.world.method_8546())) {
            return this.peakMultiplier * 0.2f;
        }
        return this.peakMultiplier;
    }

    public static float getSunBrightness(class_1937 world, float tickDelta) {
        float t = world.method_30274(tickDelta);
        float curve = 1.0f - (class_3532.method_15362((float)(t * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        curve = class_3532.method_15363((float)curve, (float)0.0f, (float)1.0f);
        curve = 1.0f - curve;
        curve = (float)((double)curve * (1.0 - (double)(world.method_8430(tickDelta) * 5.0f) / 16.0));
        curve = (float)((double)curve * (1.0 - (double)(world.method_8478(tickDelta) * 5.0f) / 16.0));
        return curve * 0.8f + 0.2f;
    }

    public static boolean canSeeSun(class_1937 world, class_2338 pos) {
        if (world == null) {
            return false;
        }
        if (!world.method_8597().comp_642()) {
            return false;
        }
        if (world.method_8594() >= 4) {
            return false;
        }
        return world.method_8311(pos);
    }

    private static float resolveDownfall(class_1959 biome) {
        try {
            Method m = class_1959.class.getMethod("getDownfall", new Class[0]);
            return ((Float)m.invoke((Object)biome, new Object[0])).floatValue();
        }
        catch (NoSuchMethodException e1) {
            try {
                Method m = class_1959.class.getMethod("downfall", new Class[0]);
                return ((Float)m.invoke((Object)biome, new Object[0])).floatValue();
            }
            catch (NoSuchMethodException e2) {
                try {
                    Field wf = class_1959.class.getDeclaredField("weather");
                    wf.setAccessible(true);
                    Object weather = wf.get(biome);
                    if (weather == null) {
                        return 0.0f;
                    }
                    try {
                        Method dm = weather.getClass().getMethod("downfall", new Class[0]);
                        return ((Float)dm.invoke(weather, new Object[0])).floatValue();
                    }
                    catch (NoSuchMethodException e3) {
                        try {
                            Field df = weather.getClass().getDeclaredField("downfall");
                            df.setAccessible(true);
                            return df.getFloat(weather);
                        }
                        catch (Exception e4) {
                            return 0.0f;
                        }
                    }
                }
                catch (Exception e3) {
                    return 0.0f;
                }
            }
            catch (Exception e2b) {
                return 0.0f;
            }
        }
        catch (Exception e) {
            return 0.0f;
        }
    }
}

