/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia;

import com.mojang.logging.LogUtils;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.effect.ModMobEffects;
import net.astralya.hexalia.entity.ModEntities;
import net.astralya.hexalia.entity.custom.client.ModBoatRenderer;
import net.astralya.hexalia.entity.custom.client.SilkMothRenderer;
import net.astralya.hexalia.item.ModCreativeModeTabs;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.loot.ModLootModifiers;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.screen.ModMenuTypes;
import net.astralya.hexalia.screen.SmallCauldronScreen;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.astralya.hexalia.util.ModRegistries;
import net.astralya.hexalia.util.ModWoodTypes;
import net.astralya.hexalia.worldgen.gen.decorator.ModTreeDecorators;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="hexalia")
public class HexaliaMod {
    public static final String MODID = "hexalia";
    private static final Logger LOGGER = LogUtils.getLogger();

    public HexaliaMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModMobEffects.register(modEventBus);
        ModSoundEvents.register(modEventBus);
        ModParticleType.register(modEventBus);
        ModBlockEntityTypes.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        ModTreeDecorators.register(modEventBus);
        ModEntities.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        Configuration.register();
        GeckoLib.initialize();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModRegistries.registerCompostable();
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.SPIRIT_BLOOM.getId(), ModBlocks.POTTED_SPIRIT_BLOOM);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.DREAMSHROOM.getId(), ModBlocks.POTTED_DREAMSHROOM);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.GHOST_FERN.getId(), ModBlocks.POTTED_GHOST_FERN);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.CELESTIAL_BLOOM.getId(), ModBlocks.POTTED_CELESTIAL_BLOOM);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.NIGHTSHADE_BUSH.getId(), ModBlocks.POTTED_NIGHTSHADE_BUSH);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.COTTONWOOD_SAPLING.getId(), ModBlocks.POTTED_COTTONWOOD_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.WILLOW_SAPLING.getId(), ModBlocks.POTTED_WILLOW_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.BEGONIA.getId(), ModBlocks.POTTED_BEGONIA);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.LAVENDER.getId(), ModBlocks.POTTED_LAVENDER);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.MORPHORA.getId(), ModBlocks.POTTED_MORPHORA);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.GRIMSHADE.getId(), ModBlocks.POTTED_GRIMSHADE);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.WINDSONG.getId(), ModBlocks.POTTED_WINDSONG);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.ASTRYLIS.getId(), ModBlocks.POTTED_ASTRYLIS);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(ModBlocks.DAHLIA.getId(), ModBlocks.POTTED_DAHLIA);
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == ModCreativeModeTabs.HEXALIA_TAB.get() && ModList.get().isLoaded("patchouli")) {
            event.accept(ModItems.VERDANT_GRIMOIRE);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="hexalia", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SMALL_CAULDRON_MENU.get()), SmallCauldronScreen::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_BOAT.get()), pContext -> new ModBoatRenderer(pContext, false));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MOD_CHEST_BOAT.get()), pContext -> new ModBoatRenderer(pContext, true));
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.RABBAGE.get()), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.FOUL_SAC.get()), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.FROST_SAC.get()), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.PURIFYING_SAC.get()), ThrownItemRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SILK_MOTH_ENTITY.get()), SilkMothRenderer::new);
            Sheets.addWoodType((WoodType)ModWoodTypes.COTTONWOOD);
            Sheets.addWoodType((WoodType)ModWoodTypes.WILLOW);
        }
    }
}

