/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import net.astralya.hexalia.entity.ModEntities;
import net.astralya.hexalia.entity.custom.SilkMothEntity;
import net.astralya.hexalia.entity.variant.SilkMothVariant;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CocoonBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty HATCH = IntegerProperty.m_61631_((String)"hatch", (int)0, (int)2);
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83064_((AABB)new AABB(0.3125, 0.3125, 0.6875, 0.6875, 0.75, 1.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83064_((AABB)new AABB(0.3125, 0.3125, 0.0, 0.6875, 0.75, 0.3125));
    private static final VoxelShape WEST_SHAPE = Shapes.m_83064_((AABB)new AABB(0.6875, 0.3125, 0.3125, 1.0, 0.75, 0.6875));
    private static final VoxelShape EAST_SHAPE = Shapes.m_83064_((AABB)new AABB(0.0, 0.3125, 0.3125, 0.3125, 0.75, 0.6875));

    public CocoonBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockItem blockItem;
        Block block;
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()).m_49966_().m_60791_() > 8) {
            pLevel.m_186460_(pPos, (Block)this, 200);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_7471_(pPos, false);
        SilkMothEntity silkMoth = (SilkMothEntity)((EntityType)ModEntities.SILK_MOTH_ENTITY.get()).m_20615_((Level)pLevel);
        if (silkMoth != null) {
            silkMoth.m_7678_((double)pPos.m_123341_() + 0.5, pPos.m_123342_(), (double)pPos.m_123343_() + 0.5, 0.0f, 0.0f);
            SilkMothVariant variant = SilkMothVariant.byId(pRandom.m_188503_(SilkMothVariant.values().length));
            silkMoth.setSilkMothVariant(variant);
            pLevel.m_7967_((Entity)silkMoth);
        }
        pLevel.m_142346_(null, GameEvent.f_157794_, pPos);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        return switch (direction) {
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection.m_122424_() == pState.m_61143_((Property)FACING) && !pState.m_60710_((LevelReader)pLevel, pPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        BlockPos oppositePos = pPos.m_121945_(facing.m_122424_());
        BlockState oppositeState = pLevel.m_8055_(oppositePos);
        return oppositeState.m_204336_(ModTags.Blocks.COCOON_LOGS);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, HATCH});
    }
}

