/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.EnchantedPlantBlock;
import net.astralya.hexalia.block.entity.custom.GrimshadeBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class GrimshadeBlock
extends EnchantedPlantBlock
implements EntityBlock {
    public GrimshadeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return super.m_6266_(state, level, pos) || state.m_60713_(Blocks.f_50134_) || state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        GrimshadeBlockEntity grim;
        BlockEntity be;
        ItemStack held = player.m_21120_(hand);
        if (held.m_41720_() != ModItems.HEX_FOCUS.get()) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_ && (be = level.m_7702_(pos)) instanceof GrimshadeBlockEntity && !(grim = (GrimshadeBlockEntity)be).isActive()) {
            this.playActivationEffects((ServerLevel)level, pos);
            this.doOneShotConversions((ServerLevel)level, pos);
            grim.activate();
        }
        return InteractionResult.SUCCESS;
    }

    private void playActivationEffects(ServerLevel level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_12554_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_5594_(null, pos, SoundEvents.f_12404_, SoundSource.BLOCKS, 0.8f, 1.0f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.5, 24, 0.35, 0.35, 0.35, 0.02);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, 16, 0.35, 0.35, 0.35, 0.01);
    }

    private void doOneShotConversions(ServerLevel level, BlockPos pos) {
        AABB area = new AABB(pos).m_82400_(2.5);
        for (Object e : level.m_45976_(Skeleton.class, area)) {
            WitherSkeleton wither = (WitherSkeleton)EntityType.f_20497_.m_20615_((Level)level);
            wither.m_7678_(e.m_20185_(), e.m_20186_(), e.m_20189_(), e.m_146908_(), e.m_146909_());
            e.m_146870_();
            level.m_7967_((Entity)wither);
        }
        int[] skulls = new int[]{0};
        for (ItemEntity it : level.m_6443_(ItemEntity.class, area, ent -> ent.m_32055_().m_150930_(Items.f_42678_) && skulls[0] < 3)) {
            it.m_32045_(new ItemStack((ItemLike)Items.f_42679_, it.m_32055_().m_41613_()));
            skulls[0] = skulls[0] + 1;
        }
        int minX = (int)Math.floor(area.f_82288_);
        int minY = (int)Math.floor(area.f_82289_);
        int minZ = (int)Math.floor(area.f_82290_);
        int maxX = (int)Math.floor(area.f_82291_);
        int maxY = (int)Math.floor(area.f_82292_);
        int maxZ = (int)Math.floor(area.f_82293_);
        for (BlockPos p : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockState t;
            if (skulls[0] >= 3) break;
            BlockState s = level.m_8055_(p);
            if (s.m_60713_(Blocks.f_50310_)) {
                t = GrimshadeBlock.copyCommonProperties(s, Blocks.f_50312_.m_49966_());
                level.m_7731_(p, t, 3);
                skulls[0] = skulls[0] + 1;
                continue;
            }
            if (s.m_60713_(Blocks.f_50311_)) {
                t = Blocks.f_50313_.m_49966_();
                t = GrimshadeBlock.copyCommonProperties(s, t);
                if (s.m_61138_((Property)WallSkullBlock.f_58097_) && t.m_61138_((Property)WallSkullBlock.f_58097_)) {
                    t = (BlockState)t.m_61124_((Property)WallSkullBlock.f_58097_, (Comparable)((Direction)s.m_61143_((Property)WallSkullBlock.f_58097_)));
                }
                level.m_7731_(p, t, 3);
                skulls[0] = skulls[0] + 1;
                continue;
            }
            if (!s.m_60713_((Block)ModBlocks.CANDLE_SKULL.get())) continue;
            t = GrimshadeBlock.copyCommonProperties(s, ((Block)ModBlocks.WITHER_CANDLE_SKULL.get()).m_49966_());
            level.m_7731_(p, t, 3);
            skulls[0] = skulls[0] + 1;
        }
    }

    private static BlockState copyCommonProperties(BlockState from, BlockState to) {
        for (Property prop : from.m_61147_()) {
            if (!to.m_61138_(prop)) continue;
            to = (BlockState)to.m_61124_(prop, from.m_61143_(prop));
        }
        return to;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return super.m_5573_(ctx);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GrimshadeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : (lvl, p, s, be) -> {
            if (be instanceof GrimshadeBlockEntity) {
                GrimshadeBlockEntity g = (GrimshadeBlockEntity)be;
                GrimshadeBlockEntity.tick(lvl, p, s, g);
            }
        };
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        GrimshadeBlockEntity g;
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof LivingEntity) || entity instanceof Player) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof GrimshadeBlockEntity && (g = (GrimshadeBlockEntity)be).isActive()) {
            g.applyCollisionPing((LivingEntity)entity);
        }
    }
}

