/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.astralya.hexalia.block.custom.RitualBrazierBlock;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.RitualBrazierBlockEntity;
import net.astralya.hexalia.block.entity.custom.RitualTableBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RitualTableBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.125, (double)0.8125), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)0.625, (double)0.75), Shapes.m_83048_((double)0.1875, (double)0.625, (double)0.1875, (double)0.8125, (double)0.6875, (double)0.8125), Shapes.m_83048_((double)0.125, (double)0.6875, (double)0.125, (double)0.875, (double)0.8125, (double)0.875)});

    public RitualTableBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        b.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RitualTableBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity be;
        if (state.m_60734_() != newState.m_60734_() && (be = level.m_7702_(pos)) instanceof RitualTableBlockEntity) {
            RitualTableBlockEntity tableBE = (RitualTableBlockEntity)be;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)tableBE);
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof RitualTableBlockEntity)) {
            return InteractionResult.PASS;
        }
        RitualTableBlockEntity tableBE = (RitualTableBlockEntity)be;
        ItemStack held = player.m_21120_(hand);
        if (held.m_41619_() && !tableBE.m_7983_()) {
            this.removeItemFromBlock(level, pos, player, tableBE);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!held.m_41619_() && tableBE.m_7983_() && !held.m_150930_((Item)ModItems.HEX_FOCUS.get())) {
            this.addItemToBlock(held, level, pos, player, tableBE);
            this.spawnParticles(level, pos, ParticleTypes.f_123759_, 5, 10);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (held.m_150930_((Item)ModItems.HEX_FOCUS.get())) {
            if (this.tryStartRitual(level, pos, player, tableBE)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private void addItemToBlock(ItemStack held, Level level, BlockPos pos, Player player, RitualTableBlockEntity table) {
        table.m_6836_(0, held);
        if (!player.m_150110_().f_35937_) {
            held.m_41774_(1);
        }
        this.playPickupPlaceSounds(level, pos);
    }

    private void removeItemFromBlock(Level level, BlockPos pos, Player player, RitualTableBlockEntity table) {
        ItemStack fromTable = table.m_8020_(0);
        if (!fromTable.m_41619_()) {
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(InteractionHand.MAIN_HAND, fromTable);
            } else {
                player.m_21008_(InteractionHand.MAIN_HAND, fromTable.m_41777_());
            }
            table.m_6211_();
            this.playPickupPlaceSounds(level, pos);
        }
    }

    private boolean tryStartRitual(Level level, BlockPos pos, Player player, RitualTableBlockEntity tableBE) {
        ItemStack tableItem = tableBE.m_8020_(0);
        if (tableItem.m_41619_()) {
            this.failWithMessage(level, pos, player, "message.hexalia.ritual.missing_ingredients");
            return true;
        }
        BlockPos[] offsets = new BlockPos[]{pos.m_122013_(2), pos.m_122020_(2), pos.m_122030_(2), pos.m_122025_(2)};
        ArrayList<RitualBrazierBlockEntity> filledBraziers = new ArrayList<RitualBrazierBlockEntity>();
        for (BlockPos bPos : offsets) {
            RitualBrazierBlockEntity brazier;
            ItemStack stored;
            BlockEntity blockEntity = level.m_7702_(bPos);
            if (!(blockEntity instanceof RitualBrazierBlockEntity) || (stored = (brazier = (RitualBrazierBlockEntity)blockEntity).getStoredItem()).m_41619_()) continue;
            filledBraziers.add(brazier);
        }
        MatchResult match = this.findMatching(level, tableItem, filledBraziers);
        if (match == null) {
            this.failWithMessage(level, pos, player, "message.hexalia.ritual.wrong_recipe");
            return true;
        }
        for (RitualBrazierBlockEntity brazier : match.usedBraziers) {
            BlockState bs = level.m_8055_(brazier.m_58899_());
            if (bs.m_61138_((Property)RitualBrazierBlock.SALTED) && ((Boolean)bs.m_61143_((Property)RitualBrazierBlock.SALTED)).booleanValue()) continue;
            this.failWithMessage(level, pos, player, "message.hexalia.ritual.missing_salt");
            return true;
        }
        List<BlockPos> grownCrops = this.findFullyGrownCrops(level, pos, 8, 8);
        if (grownCrops.size() < 8) {
            this.failWithMessage(level, pos, player, "message.hexalia.ritual.invalid_crops");
            return true;
        }
        int duration = match.usedBraziers.size() * 40;
        tableBE.startTransformation(match.recipe.m_8043_(level.m_9598_()).m_41777_(), duration, match.usedBraziers, grownCrops);
        tableBE.setGrownCropPositions(grownCrops);
        this.playPickupPlaceSounds(level, pos);
        this.spawnParticles(level, pos, ParticleTypes.f_123759_, 5, 10);
        return true;
    }

    @Nullable
    private MatchResult findMatching(Level level, ItemStack tableItem, List<RitualBrazierBlockEntity> availableBraziers) {
        List candidates = level.m_7465_().m_44013_((RecipeType)RitualTableRecipe.Type.INSTANCE);
        for (RitualTableRecipe recipe : candidates) {
            NonNullList<Ingredient> ings = recipe.m_7527_();
            if (ings.isEmpty() || !((Ingredient)ings.get(0)).test(tableItem)) continue;
            List needed = ings.subList(1, ings.size());
            ArrayList<RitualBrazierBlockEntity> pool = new ArrayList<RitualBrazierBlockEntity>(availableBraziers);
            ArrayList<RitualBrazierBlockEntity> used = new ArrayList<RitualBrazierBlockEntity>();
            boolean ok = true;
            for (Ingredient ing : needed) {
                int idx = -1;
                for (int i = 0; i < pool.size(); ++i) {
                    if (!ing.test(((RitualBrazierBlockEntity)((Object)pool.get(i))).getStoredItem())) continue;
                    idx = i;
                    break;
                }
                if (idx == -1) {
                    ok = false;
                    break;
                }
                used.add((RitualBrazierBlockEntity)((Object)pool.remove(idx)));
            }
            if (!ok) continue;
            return new MatchResult(recipe, used);
        }
        return null;
    }

    private List<BlockPos> findFullyGrownCrops(Level level, BlockPos center, int requiredCount, int radius) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                CropBlock crop;
                BlockPos p = center.m_7918_(dx, 0, dz);
                BlockState s = level.m_8055_(p);
                Block block = s.m_60734_();
                if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).m_52307_(s)) continue;
                found.add(p);
                if (found.size() < requiredCount) continue;
                return found;
            }
        }
        return found;
    }

    private void failWithMessage(Level level, BlockPos pos, Player player, String key) {
        this.spawnParticles(level, pos, ParticleTypes.f_123762_, 8, 12);
        if (!level.f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)key), true);
        }
        level.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 0.4f, 0.6f);
    }

    private void spawnParticles(Level level, BlockPos pos, SimpleParticleType type, int min, int max) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int count = ThreadLocalRandom.current().nextInt(min, max);
            for (int i = 0; i < count; ++i) {
                double x = (double)pos.m_123341_() + 0.5 + ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
                double y = (double)pos.m_123342_() + 1.0 + ThreadLocalRandom.current().nextDouble(0.0, 0.5);
                double z = (double)pos.m_123343_() + 0.5 + ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
                server.m_8767_((ParticleOptions)type, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void playPickupPlaceSounds(Level level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_257000_, SoundSource.BLOCKS, 0.8f, 0.5f);
        level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.8f, 0.5f);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.f_46443_ && type == ModBlockEntityTypes.RITUAL_TABLE_BE.get() ? (lvl, p, st, be) -> RitualTableBlockEntity.serverTick(lvl, p, st, (RitualTableBlockEntity)be) : null;
    }

    private static final class MatchResult {
        final RitualTableRecipe recipe;
        final List<RitualBrazierBlockEntity> usedBraziers;

        MatchResult(RitualTableRecipe recipe, List<RitualBrazierBlockEntity> usedBraziers) {
            this.recipe = recipe;
            this.usedBraziers = usedBraziers;
        }
    }
}

