/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.astralya.hexalia.block.entity.custom.ShelfBlockEntity;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> SHAPES = ShelfBlock.createShapes();

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static VoxelShape createShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.5, (double)1.0, (double)0.3125, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static Map<Direction, VoxelShape> createShapes() {
        HashMap<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();
        VoxelShape baseShape = ShelfBlock.createShape();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            shapes.put(direction, ShelfBlock.rotateShape(Direction.NORTH, direction, baseShape));
        }
        return shapes;
    }

    private static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction face = ctx.m_43719_();
        if (face.m_122434_().m_122479_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face.m_122424_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ShelfBlockEntity) {
            double relativeZ;
            double relativeX;
            ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
            Vec3 hitPos = hit.m_82450_();
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            double x = hitPos.m_7096_() - (double)pos.m_123341_();
            double y = hitPos.m_7098_() - (double)pos.m_123342_();
            double z = hitPos.m_7094_() - (double)pos.m_123343_();
            switch (facing) {
                case NORTH: {
                    relativeX = 1.0 - x;
                    relativeZ = z;
                    break;
                }
                case SOUTH: {
                    relativeX = x;
                    relativeZ = 1.0 - z;
                    break;
                }
                case EAST: {
                    relativeX = 1.0 - z;
                    relativeZ = 1.0 - x;
                    break;
                }
                case WEST: {
                    relativeX = z;
                    relativeZ = x;
                    break;
                }
                default: {
                    return InteractionResult.PASS;
                }
            }
            if (relativeZ < 0.5 || relativeZ > 1.0 || y < 0.25 || y > 0.75) {
                return InteractionResult.PASS;
            }
            int row = relativeZ < 0.75 ? 1 : 0;
            int column = relativeX < 0.33 ? 0 : (relativeX < 0.67 ? 1 : 2);
            int slot = column + row * 3;
            ItemStack heldItem = player.m_21120_(hand);
            ItemStack shelfItem = shelf.getItem(slot);
            if (!shelfItem.m_41619_()) {
                ItemStack removedItem = shelf.removeStack(slot);
                level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_150109_().m_36054_(removedItem)) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)removedItem);
                }
                level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (this.isValidItem(heldItem)) {
                ItemStack toPlace;
                if (player.m_7500_()) {
                    toPlace = heldItem.m_41777_();
                    toPlace.m_41764_(1);
                } else {
                    toPlace = heldItem.m_41620_(1);
                }
                shelf.setItem(slot, toPlace);
                level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private boolean isValidItem(ItemStack stack) {
        return !stack.m_41619_() && stack.m_204117_(ModTags.Items.BREWS) || stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42739_) || stack.m_150930_(Items.f_42736_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        BlockPos supportPos = pos.m_121945_(direction);
        BlockState supportState = level.m_8055_(supportPos);
        return supportState.m_60783_((BlockGetter)level, supportPos, direction.m_122424_());
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ShelfBlockEntity) {
                ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
                if (world instanceof ServerLevel) {
                    for (int i = 0; i < 6; ++i) {
                        ItemStack stack = shelf.getItem(i);
                        if (stack.m_41619_()) continue;
                        Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                    }
                }
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.hexalia.shelf").m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }
}

