/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.List;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GrimshadeBlockEntity
extends BlockEntity {
    private int activeTicks = 0;
    private long activationTime = -1L;

    public GrimshadeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.GRIMSHADE_BE.get(), pos, state);
    }

    private static int duration() {
        return Math.max(1, (Integer)Configuration.GRIMSHADE_DURATION.get());
    }

    private static int effectRadius() {
        return Math.max(1, (Integer)Configuration.GRIMSHADE_EFFECT_RADIUS.get());
    }

    public void activate() {
        this.activeTicks = GrimshadeBlockEntity.duration();
        if (this.f_58857_ != null) {
            this.activationTime = this.f_58857_.m_46467_();
        }
        this.m_6596_();
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GrimshadeBlockEntity be) {
        if (be.activationTime != -1L && level != null) {
            long now = level.m_46467_();
            long elapsed = now - be.activationTime;
            int expected = GrimshadeBlockEntity.duration() - (int)elapsed;
            if (Math.abs(be.activeTicks - expected) > 5) {
                be.activeTicks = Math.max(0, expected);
            }
        }
        if (!be.isActive()) {
            return;
        }
        --be.activeTicks;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (server.m_46791_() != Difficulty.PEACEFUL) {
                int r = GrimshadeBlockEntity.effectRadius();
                AABB area = new AABB(pos).m_82400_((double)r);
                List targets = server.m_6443_(LivingEntity.class, area, e -> e.m_6084_() && !(e instanceof Player));
                for (LivingEntity mob : targets) {
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 0, true, true));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 0, true, true));
                }
            }
            GrimshadeBlockEntity.emitParticles(server, pos);
        }
        if (be.activeTicks <= 0) {
            level.m_5594_(null, pos, SoundEvents.f_215750_, SoundSource.BLOCKS, 0.6f, 0.7f);
            be.m_6596_();
        } else {
            be.m_6596_();
        }
    }

    public void applyCollisionPing(LivingEntity e) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.f_58857_.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        if (e instanceof Player) {
            return;
        }
        e.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 0, true, true));
        e.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 0, true, true));
    }

    private static void emitParticles(ServerLevel level, BlockPos pos) {
        if (level.f_46441_.m_188503_(3) != 0) {
            return;
        }
        Vec3 c = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5);
        RandomSource rand = level.f_46441_;
        int count = 6 + rand.m_188503_(4);
        for (int i = 0; i < count; ++i) {
            double ox = (rand.m_188500_() - 0.5) * 0.6;
            double oy = rand.m_188500_() * 0.5;
            double oz = (rand.m_188500_() - 0.5) * 0.6;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, c.f_82479_ + ox, c.f_82480_ + oy, c.f_82481_ + oz, 1, 0.0, 0.001, 0.0, 0.0);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("ActiveTicks", this.activeTicks);
        tag.m_128356_("ActivationTime", this.activationTime);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.activeTicks = tag.m_128451_("ActiveTicks");
        this.activationTime = tag.m_128454_("ActivationTime");
        if (this.activationTime != -1L && this.f_58857_ != null && this.activeTicks > 0) {
            long now = this.f_58857_.m_46467_();
            long elapsed = now - this.activationTime;
            this.activeTicks = Math.max(0, GrimshadeBlockEntity.duration() - (int)elapsed);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("ActiveTicks", this.activeTicks);
        tag.m_128356_("ActivationTime", this.activationTime);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

