/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.astralya.hexalia.block.custom.CenserBlock;
import net.astralya.hexalia.block.entity.custom.CenserBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CenserBlockRenderer
implements BlockEntityRenderer<CenserBlockEntity> {
    private final ItemRenderer itemRenderer;
    private static final float ITEM_SCALE = 0.75f;
    private static final float BASE_Y_OFFSET = 0.385f;
    private static final float ITEM_SPACING = 0.02f;

    public CenserBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(@NotNull CenserBlockEntity censer, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = censer.m_58904_();
        if (level == null) {
            return;
        }
        NonNullList<ItemStack> items = censer.getItems();
        if (items.isEmpty()) {
            return;
        }
        BlockState state = censer.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)CenserBlock.FACING);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122435_()));
        float currentY = 0.385f;
        float itemX = 0.0f;
        float itemZ = -0.0625f;
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            poseStack.m_85836_();
            poseStack.m_252880_(itemX, currentY, itemZ);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            this.itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, buffer, level, (int)censer.m_58899_().m_121878_());
            poseStack.m_85849_();
            currentY += 0.02f;
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(CenserBlockEntity blockEntity) {
        return true;
    }
}

