/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.effect.custom;

import java.util.UUID;
import net.astralya.hexalia.util.SunlightCheck;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class DaybloomEffect
extends MobEffect {
    private static final int COOLDOWN = 100;
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("e1234567-89ab-cdef-0123-456789abcdef");

    public DaybloomEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        SunlightCheck sc = new SunlightCheck(player.m_9236_(), player.m_20183_());
        sc.recheckCanSeeSun();
        float gen = sc.getGenerationMultiplier();
        if (gen <= 0.0f) {
            player.m_6469_(player.m_269291_().m_269425_(), 1.5f);
            this.removeSpeedModifier(player);
            return;
        }
        float heal = 2.0f * gen;
        if (heal > 0.0f) {
            player.m_5634_(heal);
        }
        double speedBoost = 0.05 * (double)(amplifier + 1) * (double)gen;
        this.applySpeedModifier(player, speedBoost);
    }

    private void applySpeedModifier(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr == null) {
            return;
        }
        this.removeSpeedModifier(player);
        if (amount == 0.0) {
            return;
        }
        attr.m_22118_(new AttributeModifier(SPEED_MODIFIER_UUID, "Daybloom Speed Boost", amount, AttributeModifier.Operation.ADDITION));
    }

    private void removeSpeedModifier(Player player) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            attr.m_22120_(SPEED_MODIFIER_UUID);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.removeSpeedModifier(player);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 100 == 0;
    }
}

