/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import java.util.UUID;
import java.util.function.Consumer;
import net.astralya.hexalia.item.client.BoggedBootsRenderer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BoggedBootsItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final UUID SWIM_SPEED_MODIFIER_UUID = UUID.fromString("a0a7d558-2a6e-4d27-8a18-0c4f2d0a2f6f");

    public BoggedBootsItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BoggedBootsRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new BoggedBootsRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean wearing = player.m_150109_().m_36052_(0).m_150930_((Item)this);
            this.handleSwimSpeed(player, wearing);
        }
        super.m_6883_(stack, level, entity, slot, selected);
    }

    private void handleSwimSpeed(Player player, boolean add) {
        AttributeInstance inst = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        if (inst == null) {
            return;
        }
        AttributeModifier mod = new AttributeModifier(SWIM_SPEED_MODIFIER_UUID, "bogged_boots_swim_boost", 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (add) {
            if (inst.m_22111_(SWIM_SPEED_MODIFIER_UUID) == null) {
                inst.m_22125_(mod);
            }
        } else if (inst.m_22111_(SWIM_SPEED_MODIFIER_UUID) != null) {
            inst.m_22120_(SWIM_SPEED_MODIFIER_UUID);
        }
    }
}

