/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import java.util.List;
import java.util.function.Consumer;
import net.astralya.hexalia.item.client.GhostVeilRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GhostVeilItem
extends ArmorItem
implements GeoItem {
    private static final String NBT_FLAG = "Hexalia_GhostVeil_Invis";
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public GhostVeilItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GhostVeilRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new GhostVeilRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            super.m_6883_(stack, world, entity, slot, selected);
            return;
        }
        Player player = (Player)entity;
        boolean wearingThis = player.m_6844_(EquipmentSlot.CHEST).equals(stack);
        if (!world.f_46443_ && wearingThis) {
            if (player.m_6047_()) {
                MobEffectInstance cur = player.m_21124_(MobEffects.f_19609_);
                if (cur == null || cur.m_19557_() <= 10) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 20, 0, false, false, false));
                }
                player.getPersistentData().m_128379_(NBT_FLAG, true);
                if (stack.m_41763_() && world.m_46467_() % 20L == 0L) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.CHEST));
                }
            } else {
                if (player.getPersistentData().m_128471_(NBT_FLAG) && player.m_21023_(MobEffects.f_19609_)) {
                    player.m_21195_(MobEffects.f_19609_);
                }
                player.getPersistentData().m_128473_(NBT_FLAG);
            }
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hexalia.ghostveil").m_130940_(ChatFormatting.GRAY));
    }
}

