/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class RitualTableRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;
    public static final int INPUT_SLOTS = 4;

    public RitualTableRecipe(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack output) {
        this.id = id;
        this.ingredients = ingredients;
        this.output = output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean matches(SimpleContainer inv, Level level) {
        if (level.f_46443_) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0));
    }

    public ItemStack assemble(SimpleContainer inv, RegistryAccess access) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<RitualTableRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public RitualTableRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray arr = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList list = NonNullList.m_122779_();
            for (int i = 0; i < arr.size(); ++i) {
                list.add((Object)Ingredient.m_43917_((JsonElement)arr.get(i)));
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("RitualTable: ingredients array cannot be empty");
            }
            ItemStack out = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return new RitualTableRecipe(id, (NonNullList<Ingredient>)list, out);
        }

        public RitualTableRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int count = buf.m_130242_();
            NonNullList list = NonNullList.m_122780_((int)count, (Object)Ingredient.f_43901_);
            for (int i = 0; i < count; ++i) {
                list.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack out = buf.m_130267_();
            return new RitualTableRecipe(id, (NonNullList<Ingredient>)list, out);
        }

        public void toNetwork(FriendlyByteBuf buf, RitualTableRecipe recipe) {
            buf.m_130130_(recipe.ingredients.size());
            for (Ingredient ing : recipe.ingredients) {
                ing.m_43923_(buf);
            }
            buf.m_130055_(recipe.output);
        }
    }

    public static class Type
    implements RecipeType<RitualTableRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "ritual_table";
    }
}

