/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.worldgen;

import java.util.List;
import java.util.function.Supplier;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.ChillberryBushBlock;
import net.astralya.hexalia.worldgen.gen.decorator.CatkinTreeDecorator;
import net.astralya.hexalia.worldgen.gen.decorator.CocoonTreeDecorator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.DarkOakFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.DarkOakTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRIT_BLOOM = ModConfiguredFeatures.registerKey("spirit_bloom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DREAMSHROOM = ModConfiguredFeatures.registerKey("dreamshroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SIREN_KELP = ModConfiguredFeatures.registerKey("siren_kelp");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHILLBERRY = ModConfiguredFeatures.registerKey("chillberry");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_SUNFIRE_TOMATO = ModConfiguredFeatures.registerKey("wild_sunfire_tomato");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILD_MANDRAKE = ModConfiguredFeatures.registerKey("wild_mandrake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BEGONIA = ModConfiguredFeatures.registerKey("begonia");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LAVENDER = ModConfiguredFeatures.registerKey("lavender");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DAHLIA = ModConfiguredFeatures.registerKey("dahlia");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CELESTIAL_BLOOM = ModConfiguredFeatures.registerKey("celestial_bloom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GHOST_FERN = ModConfiguredFeatures.registerKey("ghost_fern");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COTTONWOOD = ModConfiguredFeatures.registerKey("cottonwood");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILLOW = ModConfiguredFeatures.registerKey("willow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DARK_OAK_COCOON = ModConfiguredFeatures.registerKey("dark_oak_cocoon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LOTUS_FLOWER = ModConfiguredFeatures.registerKey("lotus_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALE_MUSHROOM = ModConfiguredFeatures.registerKey("pale_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WITCHWEED = ModConfiguredFeatures.registerKey("witchweed");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NIGHTSHADE_BUSH = ModConfiguredFeatures.registerKey("nightshade_bush");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter blocks = context.m_255420_(Registries.f_256747_);
        ModConfiguredFeatures.registerFunctionalPlants(context);
        ModConfiguredFeatures.registerDecorativePlants(context);
        ModConfiguredFeatures.registerTrees(context);
    }

    private static void registerFunctionalPlants(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.register(context, SPIRIT_BLOOM, Feature.f_65761_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.SPIRIT_BLOOM.get(), 2, 3, 1));
        ModConfiguredFeatures.register(context, DREAMSHROOM, Feature.f_65763_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.DREAMSHROOM.get(), 2, 3, 1));
        ModConfiguredFeatures.register(context, SIREN_KELP, Feature.f_65763_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.SIREN_KELP.get(), 2, 3, 1));
        ModConfiguredFeatures.register(context, CHILLBERRY, Feature.f_65763_, new RandomPatchConfiguration(30, 8, 4, ModConfiguredFeatures.simple((BlockState)((Block)ModBlocks.CHILLBERRY_BUSH.get()).m_49966_().m_61124_((Property)ChillberryBushBlock.AGE, (Comparable)Integer.valueOf(3)))));
        ModConfiguredFeatures.register(context, WILD_SUNFIRE_TOMATO, Feature.f_65761_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.WILD_SUNFIRE_TOMATO.get(), 3, 7, 3));
        ModConfiguredFeatures.register(context, WILD_MANDRAKE, Feature.f_65761_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.WILD_MANDRAKE.get(), 3, 7, 3));
        ModConfiguredFeatures.register(context, CELESTIAL_BLOOM, Feature.f_65763_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.CELESTIAL_BLOOM.get(), 1, 7, 3));
        ModConfiguredFeatures.register(context, GHOST_FERN, Feature.f_65763_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.GHOST_FERN.get(), 1, 7, 3));
    }

    private static void registerDecorativePlants(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.register(context, BEGONIA, Feature.f_65761_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.BEGONIA.get(), 3, 7, 3));
        ModConfiguredFeatures.register(context, LAVENDER, Feature.f_65761_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.LAVENDER.get(), 15, 7, 5));
        ModConfiguredFeatures.register(context, DAHLIA, Feature.f_65761_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.DAHLIA.get(), 15, 7, 5));
        ModConfiguredFeatures.register(context, LOTUS_FLOWER, Feature.f_65763_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.LOTUS_FLOWER.get(), 5, 3, 7));
        ModConfiguredFeatures.register(context, PALE_MUSHROOM, Feature.f_65763_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.PALE_MUSHROOM.get(), 2, 2, 3));
        ModConfiguredFeatures.register(context, WITCHWEED, Feature.f_65763_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.WITCHWEED.get(), 20, 10, 5));
        ModConfiguredFeatures.register(context, NIGHTSHADE_BUSH, Feature.f_65763_, ModConfiguredFeatures.patchConfig((Block)ModBlocks.NIGHTSHADE_BUSH.get(), 3, 7, 3));
    }

    private static void registerTrees(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.register(context, DARK_OAK_COCOON, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50004_), (TrunkPlacer)new DarkOakTrunkPlacer(5, 2, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50055_), (FoliagePlacer)new DarkOakFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)1), (IntProvider)ConstantInt.m_146483_((int)0)){}, (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68249_(List.of(new CocoonTreeDecorator())).m_68251_());
        ModConfiguredFeatures.register(context, COTTONWOOD, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.COTTONWOOD_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(6, 2, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.COTTONWOOD_LEAVES.get())), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)1), 3){}, (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68249_(List.of(new CatkinTreeDecorator())).m_68251_());
        ModConfiguredFeatures.register(context, WILLOW, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.WILLOW_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.WILLOW_LEAVES.get())), (FoliagePlacer)new CherryFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)4), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)5), 0.3f, 0.7f, 0.25f, 0.5f), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68251_());
    }

    private static RandomPatchConfiguration patchConfig(Block block, int tries, int xzSpread, int ySpread) {
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block))));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("hexalia", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, config));
    }

    private static <C extends FeatureConfiguration> Supplier<C> simple(C config) {
        return () -> config;
    }

    private static Supplier<SimpleBlockConfiguration> simple(BlockStateProvider provider) {
        return () -> new SimpleBlockConfiguration(provider);
    }

    private static Supplier<SimpleBlockConfiguration> simple(Block block) {
        return ModConfiguredFeatures.simple((BlockStateProvider)BlockStateProvider.m_191382_((Block)block));
    }

    private static Holder<PlacedFeature> simple(BlockState state) {
        return PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state)));
    }
}

