/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.client.model.CopperGolemModel;
import com.github.smallinger.coppergolemlegacy.client.renderer.CopperChestRenderer;
import com.github.smallinger.coppergolemlegacy.client.renderer.CopperGolemRenderer;
import com.github.smallinger.coppergolemlegacy.client.renderer.CopperGolemStatueRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="coppergolemlegacy", dist={Dist.CLIENT})
public class CopperGolemLegacyClient {
    public CopperGolemLegacyClient(ModContainer container, IEventBus modEventBus) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modEventBus.addListener(CopperGolemLegacyClient::registerEntityRenderers);
        modEventBus.addListener(CopperGolemLegacyClient::registerLayerDefinitions);
        modEventBus.addListener(CopperGolemLegacyClient::registerBlockEntityRenderers);
        modEventBus.addListener(CopperGolemLegacyClient::onClientSetup);
    }

    static void onClientSetup(FMLClientSetupEvent event) {
        CopperGolemLegacy.LOGGER.info("HELLO FROM CLIENT SETUP");
        CopperGolemLegacy.LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
    }

    static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)CopperGolemLegacy.COPPER_GOLEM.get(), CopperGolemRenderer::new);
    }

    static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CopperGolemModel.LAYER_LOCATION, CopperGolemModel::createBodyLayer);
        event.registerLayerDefinition(CopperGolemModel.STATUE_STANDING, CopperGolemModel::createStandingStatueBodyLayer);
        event.registerLayerDefinition(CopperGolemModel.STATUE_RUNNING, CopperGolemModel::createRunningPoseBodyLayer);
        event.registerLayerDefinition(CopperGolemModel.STATUE_SITTING, CopperGolemModel::createSittingPoseBodyLayer);
        event.registerLayerDefinition(CopperGolemModel.STATUE_STAR, CopperGolemModel::createStarPoseBodyLayer);
    }

    static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)CopperGolemLegacy.COPPER_CHEST_BLOCK_ENTITY.get(), CopperChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CopperGolemLegacy.COPPER_GOLEM_STATUE_BLOCK_ENTITY.get(), CopperGolemStatueRenderer::new);
    }
}

