/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.WaxedCopperButtonBlock;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CopperButtonBlock
extends ButtonBlock
implements WeatheringCopper {
    private final WeatheringCopper.WeatherState weatherState;
    private Supplier<WaxedCopperButtonBlock> waxedButton;

    public CopperButtonBlock(WeatheringCopper.WeatherState weatherState, BlockBehaviour.Properties properties) {
        super(BlockSetType.COPPER, 15, properties);
        this.weatherState = weatherState;
    }

    public void setWaxedButton(Supplier<WaxedCopperButtonBlock> waxedButton) {
        this.waxedButton = waxedButton;
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.HONEYCOMB) && this.waxedButton != null) {
            level.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3003, pos, 0);
            if (!level.isClientSide) {
                BlockState waxedState = (BlockState)((BlockState)((BlockState)this.waxedButton.get().defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)))).setValue((Property)FACE, (Comparable)((AttachFace)state.getValue((Property)FACE)));
                level.setBlock(pos, waxedState, 11);
                if (player != null && !player.isCreative()) {
                    stack.consume(1, (LivingEntity)player);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (stack.is(ItemTags.AXES)) {
            Block previousBlock = null;
            if (this == CopperGolemLegacy.OXIDIZED_COPPER_BUTTON.get()) {
                previousBlock = (Block)CopperGolemLegacy.WEATHERED_COPPER_BUTTON.get();
            } else if (this == CopperGolemLegacy.WEATHERED_COPPER_BUTTON.get()) {
                previousBlock = (Block)CopperGolemLegacy.EXPOSED_COPPER_BUTTON.get();
            } else if (this == CopperGolemLegacy.EXPOSED_COPPER_BUTTON.get()) {
                previousBlock = (Block)CopperGolemLegacy.COPPER_BUTTON.get();
            }
            if (previousBlock != null) {
                level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.levelEvent(player, 3005, pos, 0);
                if (!level.isClientSide) {
                    BlockState newState = (BlockState)((BlockState)((BlockState)previousBlock.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)))).setValue((Property)FACE, (Comparable)((AttachFace)state.getValue((Property)FACE)));
                    level.setBlock(pos, newState, 11);
                    if (player != null && !player.isCreative()) {
                        stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.weatherState == WeatheringCopper.WeatherState.OXIDIZED) {
            level.playSound(player, pos, SoundEvents.COPPER_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.changeOverTime(state, level, pos, random);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return Optional.ofNullable(WeatheringCopper.getNext((Block)state.getBlock())).isPresent();
    }
}

