/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModSounds;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperChestBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopperChestBlock
extends ChestBlock {
    private static final Map<Block, Supplier<Block>> COPPER_TO_COPPER_CHEST_MAPPING = Map.of(Blocks.COPPER_BLOCK, () -> (Block)CopperGolemLegacy.COPPER_CHEST.get(), Blocks.EXPOSED_COPPER, () -> (Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get(), Blocks.WEATHERED_COPPER, () -> (Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get(), Blocks.OXIDIZED_COPPER, () -> (Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get(), Blocks.WAXED_COPPER_BLOCK, () -> (Block)CopperGolemLegacy.COPPER_CHEST.get(), Blocks.WAXED_EXPOSED_COPPER, () -> (Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get(), Blocks.WAXED_WEATHERED_COPPER, () -> (Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get(), Blocks.WAXED_OXIDIZED_COPPER, () -> (Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get());
    private final WeatheringCopper.WeatherState weatherState;
    private final SoundEvent openSound;
    private final SoundEvent closeSound;

    public CopperChestBlock(WeatheringCopper.WeatherState weatherState, BlockBehaviour.Properties properties) {
        super(properties, () -> (BlockEntityType)CopperGolemLegacy.COPPER_CHEST_BLOCK_ENTITY.get());
        this.weatherState = weatherState;
        this.openSound = (SoundEvent)ModSounds.COPPER_CHEST_OPEN.get();
        this.closeSound = (SoundEvent)ModSounds.COPPER_CHEST_CLOSE.get();
    }

    public MapCodec<? extends ChestBlock> codec() {
        return null;
    }

    public WeatheringCopper.WeatherState getState() {
        return this.weatherState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CopperChestBlockEntity(pos, state);
    }

    public static BlockState getFromCopperBlock(Block block, Direction direction, Level level, BlockPos pos) {
        Block chestBlock = COPPER_TO_COPPER_CHEST_MAPPING.getOrDefault(block, () -> (Block)CopperGolemLegacy.COPPER_CHEST.get()).get();
        return (BlockState)chestBlock.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }
}

