/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.block.CopperButtonBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class WaxedCopperButtonBlock
extends ButtonBlock {
    private final WeatheringCopper.WeatherState weatherState;
    private final Supplier<CopperButtonBlock> unwaxedButton;

    public WaxedCopperButtonBlock(WeatheringCopper.WeatherState weatherState, Supplier<CopperButtonBlock> unwaxedButton, BlockBehaviour.Properties properties) {
        super(BlockSetType.COPPER, 15, properties);
        this.weatherState = weatherState;
        this.unwaxedButton = unwaxedButton;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(ItemTags.AXES)) {
            level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3004, pos, 0);
            if (!level.isClientSide) {
                BlockState unwaxedState = (BlockState)((BlockState)((BlockState)this.unwaxedButton.get().defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)))).setValue((Property)FACE, (Comparable)((AttachFace)state.getValue((Property)FACE)));
                level.setBlock(pos, unwaxedState, 11);
                if (player != null && !player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

