/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block.entity;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.CopperGolemStatueBlock;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CopperGolemStatueBlockEntity
extends BlockEntity {
    @Nullable
    private Component customName;

    public CopperGolemStatueBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CopperGolemLegacy.COPPER_GOLEM_STATUE_BLOCK_ENTITY.get(), pos, state);
    }

    public void createStatue(CopperGolemEntity golem) {
        this.customName = golem.getCustomName();
        this.setChanged();
    }

    @Nullable
    public CopperGolemEntity removeStatue(BlockState state, ServerLevel level) {
        CopperGolemEntity golem = (CopperGolemEntity)((EntityType)CopperGolemLegacy.COPPER_GOLEM.get()).create((Level)level);
        if (golem != null) {
            BlockPos blockPos = this.getBlockPos();
            golem.moveTo((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5, ((Direction)state.getValue((Property)CopperGolemStatueBlock.FACING)).toYRot(), 0.0f);
            golem.yHeadRot = golem.getYRot();
            golem.yBodyRot = golem.getYRot();
            golem.setCustomName(this.customName);
            golem.setWeatherState(((CopperGolemStatueBlock)state.getBlock()).getWeatheringState());
            return golem;
        }
        return null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("CustomName")) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.customName = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
    }
}

