/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.entity;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModSounds;
import com.github.smallinger.coppergolemlegacy.block.CopperGolemStatueBlock;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperGolemStatueBlockEntity;
import com.github.smallinger.coppergolemlegacy.entity.ContainerUser;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemOxidationLevels;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemState;
import com.github.smallinger.coppergolemlegacy.entity.ai.CopperGolemAi;
import com.github.smallinger.coppergolemlegacy.entity.ai.navigation.CopperGolemNavigation;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class CopperGolemEntity
extends AbstractGolem
implements Shearable,
ContainerUser {
    private static final long IGNORE_WEATHERING_TICK = -2L;
    private static final long UNSET_WEATHERING_TICK = -1L;
    private static final int WEATHERING_TICK_FROM = 504000;
    private static final int WEATHERING_TICK_TO = 552000;
    private static final int SPIN_ANIMATION_MIN_COOLDOWN = 200;
    private static final int SPIN_ANIMATION_MAX_COOLDOWN = 240;
    private static final float TURN_TO_STATUE_CHANCE = 0.0058f;
    private static final double CONTAINER_INTERACTION_RANGE = 4.0;
    private static final EntityDataAccessor<Integer> DATA_WEATHER_STATE = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COPPER_GOLEM_STATE = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private long nextWeatheringTick = -1L;
    @Nullable
    private BlockPos openedChestPos;
    private int idleAnimationStartTick = 0;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState interactionGetItemAnimationState = new AnimationState();
    public final AnimationState interactionGetNoItemAnimationState = new AnimationState();
    public final AnimationState interactionDropItemAnimationState = new AnimationState();
    public final AnimationState interactionDropNoItemAnimationState = new AnimationState();
    public final AnimationState pressingButtonAnimationState = new AnimationState();

    private static WeatheringCopper.WeatherState getNextWeatherState(WeatheringCopper.WeatherState current) {
        return switch (current) {
            default -> throw new MatchException(null, null);
            case WeatheringCopper.WeatherState.UNAFFECTED -> WeatheringCopper.WeatherState.EXPOSED;
            case WeatheringCopper.WeatherState.EXPOSED -> WeatheringCopper.WeatherState.WEATHERED;
            case WeatheringCopper.WeatherState.WEATHERED -> WeatheringCopper.WeatherState.OXIDIZED;
            case WeatheringCopper.WeatherState.OXIDIZED -> WeatheringCopper.WeatherState.OXIDIZED;
        };
    }

    private static WeatheringCopper.WeatherState getPreviousWeatherState(WeatheringCopper.WeatherState current) {
        return switch (current) {
            default -> throw new MatchException(null, null);
            case WeatheringCopper.WeatherState.UNAFFECTED -> WeatheringCopper.WeatherState.UNAFFECTED;
            case WeatheringCopper.WeatherState.EXPOSED -> WeatheringCopper.WeatherState.UNAFFECTED;
            case WeatheringCopper.WeatherState.WEATHERED -> WeatheringCopper.WeatherState.EXPOSED;
            case WeatheringCopper.WeatherState.OXIDIZED -> WeatheringCopper.WeatherState.WEATHERED;
        };
    }

    public CopperGolemEntity(EntityType<? extends AbstractGolem> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().setMaxVisitedNodesMultiplier(3.0f);
        this.setPersistenceRequired();
        this.setCanPickUpLoot(true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DANGER_OTHER, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected Brain.Provider<CopperGolemEntity> brainProvider() {
        return CopperGolemAi.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return CopperGolemAi.makeBrain((Brain<CopperGolemEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<CopperGolemEntity> getBrain() {
        return super.getBrain();
    }

    protected PathNavigation createNavigation(Level level) {
        CopperGolemNavigation navigation = new CopperGolemNavigation((Mob)this, level);
        navigation.setCanOpenDoors(true);
        navigation.setCanPassDoors(true);
        navigation.setRequiredPathLength(48.0f);
        return navigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_WEATHER_STATE, (Object)WeatheringCopper.WeatherState.UNAFFECTED.ordinal());
        builder.define(COPPER_GOLEM_STATE, (Object)CopperGolemState.IDLE.ordinal());
    }

    public CopperGolemState getState() {
        int stateId = (Integer)this.entityData.get(COPPER_GOLEM_STATE);
        CopperGolemState[] states = CopperGolemState.values();
        return stateId >= 0 && stateId < states.length ? states[stateId] : CopperGolemState.IDLE;
    }

    public void setState(CopperGolemState state) {
        this.entityData.set(COPPER_GOLEM_STATE, (Object)state.ordinal());
    }

    public WeatheringCopper.WeatherState getWeatherState() {
        int weatherId = (Integer)this.entityData.get(DATA_WEATHER_STATE);
        WeatheringCopper.WeatherState[] states = WeatheringCopper.WeatherState.values();
        return weatherId >= 0 && weatherId < states.length ? states[weatherId] : WeatheringCopper.WeatherState.UNAFFECTED;
    }

    public void setWeatherState(WeatheringCopper.WeatherState weatherState) {
        this.entityData.set(DATA_WEATHER_STATE, (Object)weatherState.ordinal());
    }

    public void setOpenedChestPos(BlockPos openedChestPos) {
        this.openedChestPos = openedChestPos;
    }

    public void clearOpenedChestPos() {
        this.openedChestPos = null;
    }

    @Override
    public boolean hasContainerOpen(ContainerOpenersCounter openCounter, BlockPos pos) {
        return this.openedChestPos != null && this.openedChestPos.equals((Object)pos);
    }

    @Override
    public double getContainerInteractionRange() {
        return 4.0;
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("copperGolemBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("copperGolemActivityUpdate");
        CopperGolemAi.updateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putLong("next_weather_age", this.nextWeatheringTick);
        compound.putInt("weather_state", this.getWeatherState().ordinal());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.nextWeatheringTick = compound.getLong("next_weather_age");
        if (compound.contains("weather_state")) {
            int weatherId = compound.getInt("weather_state");
            WeatheringCopper.WeatherState[] states = WeatheringCopper.WeatherState.values();
            if (weatherId >= 0 && weatherId < states.length) {
                this.setWeatherState(states[weatherId]);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (!this.isNoAi()) {
                this.setupAnimationStates();
            }
        } else {
            this.updateWeathering((ServerLevel)this.level(), this.level().getRandom(), this.level().getGameTime());
        }
    }

    private void updateWeathering(ServerLevel level, RandomSource random, long dayTime) {
        if (this.nextWeatheringTick != -2L) {
            if (this.nextWeatheringTick == -1L) {
                this.nextWeatheringTick = dayTime + (long)random.nextIntBetweenInclusive(504000, 552000);
            } else {
                boolean isOxidized;
                WeatheringCopper.WeatherState weatherState = this.getWeatherState();
                boolean bl = isOxidized = weatherState == WeatheringCopper.WeatherState.OXIDIZED;
                if (dayTime >= this.nextWeatheringTick && !isOxidized) {
                    WeatheringCopper.WeatherState nextState = CopperGolemEntity.getNextWeatherState(weatherState);
                    boolean willBeOxidized = nextState == WeatheringCopper.WeatherState.OXIDIZED;
                    this.setWeatherState(nextState);
                    long l = this.nextWeatheringTick = willBeOxidized ? 0L : this.nextWeatheringTick + (long)random.nextIntBetweenInclusive(504000, 552000);
                }
                if (isOxidized && this.canTurnToStatue((Level)level)) {
                    this.turnToStatue(level);
                }
            }
        }
    }

    private boolean canTurnToStatue(Level level) {
        return level.getBlockState(this.blockPosition()).is(Blocks.AIR) && level.random.nextFloat() <= 0.0058f;
    }

    private void turnToStatue(ServerLevel level) {
        BlockPos blockPos = this.blockPosition();
        CopperGolemStatueBlock.Pose randomPose = CopperGolemStatueBlock.Pose.values()[this.random.nextInt(0, CopperGolemStatueBlock.Pose.values().length)];
        level.setBlock(blockPos, (BlockState)((BlockState)((CopperGolemStatueBlock)((Object)CopperGolemLegacy.OXIDIZED_COPPER_GOLEM_STATUE.get())).defaultBlockState().setValue(CopperGolemStatueBlock.POSE, (Comparable)((Object)randomPose))).setValue((Property)CopperGolemStatueBlock.FACING, (Comparable)Direction.fromYRot((double)this.getYRot())), 3);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CopperGolemStatueBlockEntity) {
            CopperGolemStatueBlockEntity statueEntity = (CopperGolemStatueBlockEntity)blockEntity;
            statueEntity.createStatue(this);
            this.playSound((SoundEvent)ModSounds.COPPER_GOLEM_BECOME_STATUE.get());
            level.playSound(null, blockPos, (SoundEvent)ModSounds.COPPER_STATUE_BECOME.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (this.isLeashed()) {
                this.dropLeash(true, level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS));
            }
            this.discard();
        }
    }

    private void setupAnimationStates() {
        switch (this.getState()) {
            case IDLE: {
                this.interactionGetNoItemAnimationState.stop();
                this.interactionGetItemAnimationState.stop();
                this.interactionDropItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.stop();
                this.pressingButtonAnimationState.stop();
                if (this.idleAnimationStartTick == this.tickCount) {
                    this.idleAnimationState.start(this.tickCount);
                } else if (this.idleAnimationStartTick == 0) {
                    this.idleAnimationStartTick = this.tickCount + this.random.nextInt(200, 240);
                }
                if (this.tickCount != this.idleAnimationStartTick + 10) break;
                this.playHeadSpinSound();
                this.idleAnimationStartTick = 0;
                break;
            }
            case GETTING_ITEM: {
                this.idleAnimationState.stop();
                this.idleAnimationStartTick = 0;
                this.interactionGetNoItemAnimationState.stop();
                this.interactionDropItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.stop();
                this.pressingButtonAnimationState.stop();
                this.interactionGetItemAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case GETTING_NO_ITEM: {
                this.idleAnimationState.stop();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.stop();
                this.interactionDropItemAnimationState.stop();
                this.pressingButtonAnimationState.stop();
                this.interactionGetNoItemAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case DROPPING_ITEM: {
                this.idleAnimationState.stop();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.stop();
                this.interactionGetNoItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.stop();
                this.pressingButtonAnimationState.stop();
                this.interactionDropItemAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case DROPPING_NO_ITEM: {
                this.idleAnimationState.stop();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.stop();
                this.interactionGetNoItemAnimationState.stop();
                this.interactionDropItemAnimationState.stop();
                this.pressingButtonAnimationState.stop();
                this.interactionDropNoItemAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case PRESSING_BUTTON: {
                this.idleAnimationState.stop();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.stop();
                this.interactionGetNoItemAnimationState.stop();
                this.interactionDropItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.stop();
                this.pressingButtonAnimationState.startIfStopped(this.tickCount);
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Level level = this.level();
        if (itemstack.is(Items.SHEARS) && this.readyForShearing()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.shear(SoundSource.PLAYERS);
                itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (itemstack.is(Items.HONEYCOMB) && this.nextWeatheringTick != -2L) {
            if (!level.isClientSide()) {
                level.levelEvent(null, 3003, this.blockPosition(), 0);
                this.nextWeatheringTick = -2L;
                itemstack.consume(1, (LivingEntity)player);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (itemstack.is(ItemTags.AXES)) {
            if (!level.isClientSide()) {
                WeatheringCopper.WeatherState weatherState = this.getWeatherState();
                if (this.nextWeatheringTick == -2L) {
                    level.playSound(null, (Entity)this, SoundEvents.AXE_SCRAPE, this.getSoundSource(), 1.0f, 1.0f);
                    level.levelEvent(null, 3004, this.blockPosition(), 0);
                    this.nextWeatheringTick = -1L;
                    itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    return InteractionResult.SUCCESS;
                }
                if (weatherState != WeatheringCopper.WeatherState.UNAFFECTED) {
                    level.playSound(null, (Entity)this, SoundEvents.AXE_SCRAPE, this.getSoundSource(), 1.0f, 1.0f);
                    level.levelEvent(null, 3005, this.blockPosition(), 0);
                    this.nextWeatheringTick = -1L;
                    this.setWeatherState(CopperGolemEntity.getPreviousWeatherState(weatherState));
                    itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    private void playHeadSpinSound() {
        if (!this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getSpinHeadSound(), this.getSoundSource(), 1.0f, 1.0f, false);
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).hurtSound();
    }

    protected SoundEvent getDeathSound() {
        return CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).deathSound();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).stepSound(), 1.0f, 1.0f);
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected float nextStep() {
        return this.moveDist + 0.6f;
    }

    private SoundEvent getSpinHeadSound() {
        return CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).spinHeadSound();
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.75 * (double)this.getEyeHeight(), 0.0);
    }

    public void shear(SoundSource source) {
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, source, 1.0f, 1.0f);
        ItemStack antennaItem = this.getItemBySlot(EquipmentSlot.HEAD);
        if (!antennaItem.isEmpty()) {
            this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
            this.spawnAtLocation(antennaItem, 1.5f);
        }
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.getItemBySlot(EquipmentSlot.HEAD).isEmpty();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        this.playSound(SoundEvents.IRON_GOLEM_REPAIR);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnData);
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
        super.thunderHit(level, lightning);
        WeatheringCopper.WeatherState weatherState = this.getWeatherState();
        if (weatherState != WeatheringCopper.WeatherState.UNAFFECTED) {
            this.nextWeatheringTick = -1L;
            this.setWeatherState(CopperGolemEntity.getPreviousWeatherState(weatherState));
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean result = super.hurt(source, amount);
        if (result) {
            this.setState(CopperGolemState.IDLE);
        }
        return result;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean hitByPlayer) {
        super.dropCustomDeathLoot(level, damageSource, hitByPlayer);
        ItemStack copperIngots = new ItemStack((ItemLike)Items.COPPER_INGOT, 3);
        this.spawnAtLocation(copperIngots);
    }
}

