/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.entity.ai.behavior;

import com.github.smallinger.coppergolemlegacy.ModMemoryTypes;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriConsumer;

public class TransportItemsBetweenContainers
extends Behavior<PathfinderMob> {
    public static final int TARGET_INTERACTION_TIME = 60;
    private static final int VISITED_POSITIONS_MEMORY_TIME = 6000;
    private static final int TRANSPORTED_ITEM_MAX_STACK_SIZE = 16;
    private static final int MAX_VISITED_POSITIONS = 10;
    private static final int MAX_UNREACHABLE_POSITIONS = 50;
    private static final int PASSENGER_MOB_TARGET_SEARCH_DISTANCE = 1;
    private static final int IDLE_COOLDOWN = 140;
    private static final double CLOSE_ENOUGH_TO_START_QUEUING_DISTANCE = 3.0;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_DISTANCE = 0.5;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_PATH_END_DISTANCE = 1.1;
    private static final double CLOSE_ENOUGH_TO_CONTINUE_INTERACTING_WITH_TARGET = 2.0;
    private final float speedModifier;
    private final int horizontalSearchDistance;
    private final int verticalSearchDistance;
    private final Predicate<BlockState> sourceBlockType;
    private final Predicate<BlockState> destinationBlockType;
    private final Predicate<TransportItemTarget> shouldQueueForTarget;
    private final Consumer<PathfinderMob> onStartTravelling;
    private final Map<ContainerInteractionState, OnTargetReachedInteraction> onTargetInteractionActions;
    @Nullable
    private TransportItemTarget target = null;
    private TransportItemState state;
    @Nullable
    private ContainerInteractionState interactionState;
    private int ticksSinceReachingTarget;

    public TransportItemsBetweenContainers(float speedModifier, Predicate<BlockState> sourceBlockType, Predicate<BlockState> destinationBlockType, int horizontalSearchDistance, int verticalSearchDistance, Map<ContainerInteractionState, OnTargetReachedInteraction> onTargetInteractionActions, Consumer<PathfinderMob> onStartTravelling, Predicate<TransportItemTarget> shouldQueueForTarget) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.sourceBlockType = sourceBlockType;
        this.destinationBlockType = destinationBlockType;
        this.horizontalSearchDistance = horizontalSearchDistance;
        this.verticalSearchDistance = verticalSearchDistance;
        this.onStartTravelling = onStartTravelling;
        this.shouldQueueForTarget = shouldQueueForTarget;
        this.onTargetInteractionActions = onTargetInteractionActions;
        this.state = TransportItemState.TRAVELLING;
    }

    protected void start(ServerLevel level, PathfinderMob mob, long gameTime) {
    }

    protected boolean checkExtraStartConditions(ServerLevel level, PathfinderMob mob) {
        return !mob.isLeashed();
    }

    protected boolean canStillUse(ServerLevel level, PathfinderMob mob, long gameTime) {
        return mob.getBrain().getMemory((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get()).isEmpty() && !mob.isPanicking() && !mob.isLeashed();
    }

    protected boolean timedOut(long gameTime) {
        return false;
    }

    protected void tick(ServerLevel level, PathfinderMob mob, long gameTime) {
        boolean invalidTarget = this.updateInvalidTarget(level, mob);
        if (this.target == null) {
            this.stop(level, mob, gameTime);
        } else if (!invalidTarget) {
            if (this.state.equals((Object)TransportItemState.QUEUING)) {
                this.onQueuingForTarget(this.target, (Level)level, mob);
            }
            if (this.state.equals((Object)TransportItemState.TRAVELLING)) {
                this.onTravelToTarget(this.target, (Level)level, mob);
            }
            if (this.state.equals((Object)TransportItemState.INTERACTING)) {
                this.onReachedTarget(this.target, (Level)level, mob);
            }
        }
    }

    private boolean updateInvalidTarget(ServerLevel level, PathfinderMob mob) {
        if (!this.hasValidTarget((Level)level, mob)) {
            this.stopTargetingCurrentTarget(mob);
            Optional<TransportItemTarget> optional = this.getTransportTarget(level, mob);
            if (optional.isPresent()) {
                this.target = optional.get();
                this.onStartTravelling(mob);
                this.setVisitedBlockPos(mob, (Level)level, this.target.pos);
                return true;
            }
            this.enterCooldownAfterNoMatchingTargetFound(mob);
            return true;
        }
        return false;
    }

    private void onQueuingForTarget(TransportItemTarget target, Level level, PathfinderMob mob) {
        if (!this.isAnotherMobInteractingWithTarget(target, level)) {
            this.resumeTravelling(mob);
        }
    }

    protected void onTravelToTarget(TransportItemTarget target, Level level, PathfinderMob mob) {
        if (this.isWithinTargetDistance(3.0, target, level, mob, this.getCenterPos(mob)) && this.isAnotherMobInteractingWithTarget(target, level)) {
            this.startQueuing(mob);
        } else if (this.isWithinTargetDistance(TransportItemsBetweenContainers.getInteractionRange(mob), target, level, mob, this.getCenterPos(mob))) {
            this.startOnReachedTargetInteraction(target, mob);
        } else {
            this.walkTowardsTarget(mob);
        }
    }

    private Vec3 getCenterPos(PathfinderMob mob) {
        return this.setMiddleYPosition(mob, mob.position());
    }

    protected void onReachedTarget(TransportItemTarget target, Level level, PathfinderMob mob) {
        if (!this.isWithinTargetDistance(2.0, target, level, mob, this.getCenterPos(mob))) {
            this.onStartTravelling(mob);
        } else {
            ++this.ticksSinceReachingTarget;
            this.onTargetInteraction(target, mob);
            if (this.ticksSinceReachingTarget >= 60) {
                this.doReachedTargetInteraction(mob, target.container, this::pickUpItems, (p1, p2) -> this.stopTargetingCurrentTarget(mob), this::putDownItem, (p1, p2) -> this.stopTargetingCurrentTarget(mob));
                this.onStartTravelling(mob);
            }
        }
    }

    private void startQueuing(PathfinderMob mob) {
        this.stopInPlace(mob);
        this.setTransportingState(TransportItemState.QUEUING);
    }

    private void resumeTravelling(PathfinderMob mob) {
        this.setTransportingState(TransportItemState.TRAVELLING);
        this.walkTowardsTarget(mob);
    }

    private void walkTowardsTarget(PathfinderMob mob) {
        if (this.target != null) {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)mob, (BlockPos)this.target.pos, (float)this.speedModifier, (int)0);
        }
    }

    private void startOnReachedTargetInteraction(TransportItemTarget target, PathfinderMob mob) {
        this.doReachedTargetInteraction(mob, target.container, this.onReachedInteraction(ContainerInteractionState.PICKUP_ITEM), this.onReachedInteraction(ContainerInteractionState.PICKUP_NO_ITEM), this.onReachedInteraction(ContainerInteractionState.PLACE_ITEM), this.onReachedInteraction(ContainerInteractionState.PLACE_NO_ITEM));
        this.setTransportingState(TransportItemState.INTERACTING);
    }

    private void onStartTravelling(PathfinderMob mob) {
        this.onStartTravelling.accept(mob);
        this.setTransportingState(TransportItemState.TRAVELLING);
        this.interactionState = null;
        this.ticksSinceReachingTarget = 0;
    }

    private BiConsumer<PathfinderMob, Container> onReachedInteraction(ContainerInteractionState interactionState) {
        return (mob, container) -> this.setInteractionState(interactionState);
    }

    private void setTransportingState(TransportItemState transportingState) {
        this.state = transportingState;
    }

    private void setInteractionState(ContainerInteractionState interactionState) {
        this.interactionState = interactionState;
    }

    private void onTargetInteraction(TransportItemTarget target, PathfinderMob mob) {
        mob.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(target.pos));
        this.stopInPlace(mob);
        if (this.interactionState != null) {
            Optional.ofNullable(this.onTargetInteractionActions.get((Object)this.interactionState)).ifPresent(action -> action.accept(mob, target, this.ticksSinceReachingTarget));
        }
    }

    private void doReachedTargetInteraction(PathfinderMob mob, Container container, BiConsumer<PathfinderMob, Container> pickupItem, BiConsumer<PathfinderMob, Container> pickupNoItem, BiConsumer<PathfinderMob, Container> placeItem, BiConsumer<PathfinderMob, Container> placeNoItem) {
        if (TransportItemsBetweenContainers.isPickingUpItems(mob)) {
            if (TransportItemsBetweenContainers.matchesGettingItemsRequirement(container)) {
                pickupItem.accept(mob, container);
            } else {
                pickupNoItem.accept(mob, container);
            }
        } else if (TransportItemsBetweenContainers.matchesLeavingItemsRequirement(mob, container)) {
            placeItem.accept(mob, container);
        } else {
            placeNoItem.accept(mob, container);
        }
    }

    private Optional<TransportItemTarget> getTransportTarget(ServerLevel level, PathfinderMob mob) {
        AABB aabb = this.getTargetSearchArea(mob);
        Set<GlobalPos> visited = TransportItemsBetweenContainers.getVisitedPositions(mob);
        Set<GlobalPos> unreachable = TransportItemsBetweenContainers.getUnreachablePositions(mob);
        List chunks = ChunkPos.rangeClosed((ChunkPos)new ChunkPos(mob.blockPosition()), (int)(Math.floorDiv(this.getHorizontalSearchDistance(mob), 16) + 1)).toList();
        TransportItemTarget bestTarget = null;
        double bestDistance = 3.4028234663852886E38;
        for (ChunkPos chunkPos : chunks) {
            LevelChunk chunk = level.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
            if (chunk == null) continue;
            for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                TransportItemTarget candidateTarget;
                ChestBlockEntity chestBlockEntity;
                double distance;
                if (!(blockEntity instanceof ChestBlockEntity) || !((distance = (chestBlockEntity = (ChestBlockEntity)blockEntity).getBlockPos().distToCenterSqr((Position)mob.position())) < bestDistance) || (candidateTarget = this.isTargetValidToPick(mob, (Level)level, (BlockEntity)chestBlockEntity, visited, unreachable, aabb)) == null) continue;
                bestTarget = candidateTarget;
                bestDistance = distance;
            }
        }
        return bestTarget == null ? Optional.empty() : Optional.of(bestTarget);
    }

    @Nullable
    private TransportItemTarget isTargetValidToPick(PathfinderMob mob, Level level, BlockEntity blockEntity, Set<GlobalPos> visited, Set<GlobalPos> unreachable, AABB searchArea) {
        BlockPos blockpos = blockEntity.getBlockPos();
        boolean inArea = searchArea.contains((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ());
        if (!inArea) {
            return null;
        }
        TransportItemTarget target = TransportItemTarget.tryCreatePossibleTarget(blockEntity, level);
        if (target == null) {
            return null;
        }
        boolean isValid = this.isWantedBlock(mob, target.state) && !this.isPositionAlreadyVisited(visited, unreachable, target, level) && !this.isContainerLocked(target);
        return isValid ? target : null;
    }

    private boolean isContainerLocked(TransportItemTarget target) {
        return false;
    }

    private boolean hasValidTarget(Level level, PathfinderMob mob) {
        boolean hasTarget;
        boolean bl = hasTarget = this.target != null && this.isWantedBlock(mob, this.target.state) && this.targetHasNotChanged(level, this.target);
        if (hasTarget && !this.isTargetBlocked(level, this.target)) {
            if (!this.state.equals((Object)TransportItemState.TRAVELLING)) {
                return true;
            }
            if (this.hasValidTravellingPath(level, this.target, mob)) {
                return true;
            }
            this.markVisitedBlockPosAsUnreachable(mob, level, this.target.pos);
        }
        return false;
    }

    private boolean hasValidTravellingPath(Level level, TransportItemTarget target, PathfinderMob mob) {
        Path path = mob.getNavigation().getPath() == null ? mob.getNavigation().createPath(target.pos, 0) : mob.getNavigation().getPath();
        Vec3 vec3 = this.getPositionToReachTargetFrom(path, mob);
        boolean withinRange = this.isWithinTargetDistance(TransportItemsBetweenContainers.getInteractionRange(mob), target, level, mob, vec3);
        boolean noPathAndNotInRange = path == null && !withinRange;
        return noPathAndNotInRange || this.targetIsReachableFromPosition(level, withinRange, vec3, target, mob);
    }

    private Vec3 getPositionToReachTargetFrom(@Nullable Path path, PathfinderMob mob) {
        boolean noPath = path == null || path.getEndNode() == null;
        Vec3 vec3 = noPath ? mob.position() : path.getEndNode().asBlockPos().getBottomCenter();
        return this.setMiddleYPosition(mob, vec3);
    }

    private Vec3 setMiddleYPosition(PathfinderMob mob, Vec3 pos) {
        return pos.add(0.0, mob.getBoundingBox().getYsize() / 2.0, 0.0);
    }

    private boolean isTargetBlocked(Level level, TransportItemTarget target) {
        return ChestBlock.isChestBlockedAt((LevelAccessor)level, (BlockPos)target.pos);
    }

    private boolean targetHasNotChanged(Level level, TransportItemTarget target) {
        return target.blockEntity.equals(level.getBlockEntity(target.pos));
    }

    private Stream<TransportItemTarget> getConnectedTargets(TransportItemTarget target, Level level) {
        if (target.state.hasProperty((Property)ChestBlock.TYPE) && target.state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            Direction facing = (Direction)target.state.getValue((Property)ChestBlock.FACING);
            ChestType chestType = (ChestType)target.state.getValue((Property)ChestBlock.TYPE);
            Direction connectedDir = chestType == ChestType.LEFT ? facing.getClockWise() : facing.getCounterClockWise();
            BlockPos connectedPos = target.pos.relative(connectedDir);
            TransportItemTarget connectedTarget = TransportItemTarget.tryCreatePossibleTarget(level.getBlockEntity(connectedPos), level);
            return connectedTarget != null ? Stream.of(target, connectedTarget) : Stream.of(target);
        }
        return Stream.of(target);
    }

    private AABB getTargetSearchArea(PathfinderMob mob) {
        int horizontal = this.getHorizontalSearchDistance(mob);
        return new AABB(mob.blockPosition()).inflate((double)horizontal, (double)this.getVerticalSearchDistance(mob), (double)horizontal);
    }

    private int getHorizontalSearchDistance(PathfinderMob mob) {
        return mob.isPassenger() ? 1 : this.horizontalSearchDistance;
    }

    private int getVerticalSearchDistance(PathfinderMob mob) {
        return mob.isPassenger() ? 1 : this.verticalSearchDistance;
    }

    private static Set<GlobalPos> getVisitedPositions(PathfinderMob mob) {
        return mob.getBrain().getMemory((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get()).orElse(Set.of());
    }

    private static Set<GlobalPos> getUnreachablePositions(PathfinderMob mob) {
        return mob.getBrain().getMemory((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get()).orElse(Set.of());
    }

    private boolean isPositionAlreadyVisited(Set<GlobalPos> visited, Set<GlobalPos> unreachable, TransportItemTarget target, Level level) {
        return this.getConnectedTargets(target, level).map(t -> new GlobalPos(level.dimension(), t.pos)).anyMatch(globalPos -> visited.contains(globalPos) || unreachable.contains(globalPos));
    }

    private static boolean hasFinishedPath(PathfinderMob mob) {
        return mob.getNavigation().getPath() != null && mob.getNavigation().getPath().isDone();
    }

    protected void setVisitedBlockPos(PathfinderMob mob, Level level, BlockPos pos) {
        HashSet<GlobalPos> visited = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(mob));
        visited.add(new GlobalPos(level.dimension(), pos));
        if (visited.size() > 10) {
            this.enterCooldownAfterNoMatchingTargetFound(mob);
        } else {
            mob.getBrain().setMemoryWithExpiry((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get(), visited, 6000L);
        }
    }

    protected void markVisitedBlockPosAsUnreachable(PathfinderMob mob, Level level, BlockPos pos) {
        HashSet<GlobalPos> visited = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(mob));
        visited.remove(new GlobalPos(level.dimension(), pos));
        HashSet<GlobalPos> unreachable = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getUnreachablePositions(mob));
        unreachable.add(new GlobalPos(level.dimension(), pos));
        if (unreachable.size() > 50) {
            this.enterCooldownAfterNoMatchingTargetFound(mob);
        } else {
            mob.getBrain().setMemoryWithExpiry((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get(), visited, 6000L);
            mob.getBrain().setMemoryWithExpiry((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get(), unreachable, 6000L);
        }
    }

    private boolean isWantedBlock(PathfinderMob mob, BlockState state) {
        return TransportItemsBetweenContainers.isPickingUpItems(mob) ? this.sourceBlockType.test(state) : this.destinationBlockType.test(state);
    }

    private static double getInteractionRange(PathfinderMob mob) {
        return TransportItemsBetweenContainers.hasFinishedPath(mob) ? 1.1 : 0.5;
    }

    private boolean isWithinTargetDistance(double distance, TransportItemTarget target, Level level, PathfinderMob mob, Vec3 center) {
        AABB mobBounds = mob.getBoundingBox();
        AABB centerBounds = AABB.ofSize((Vec3)center, (double)mobBounds.getXsize(), (double)mobBounds.getYsize(), (double)mobBounds.getZsize());
        return target.state.getCollisionShape((BlockGetter)level, target.pos).bounds().inflate(distance, distance, distance).move(target.pos).intersects(centerBounds);
    }

    private boolean targetIsReachableFromPosition(Level level, boolean withinDistance, Vec3 targetPos, TransportItemTarget target, PathfinderMob mob) {
        return withinDistance && this.canSeeAnyTargetSide(target, level, mob, targetPos);
    }

    private boolean canSeeAnyTargetSide(TransportItemTarget target, Level level, PathfinderMob mob, Vec3 pos) {
        Vec3 targetCenter = target.pos.getCenter();
        return Direction.stream().map(dir -> targetCenter.add(0.5 * (double)dir.getStepX(), 0.5 * (double)dir.getStepY(), 0.5 * (double)dir.getStepZ())).map(sidePos -> level.clip(new ClipContext(pos, sidePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob))).anyMatch(hitResult -> hitResult.getType() == HitResult.Type.BLOCK && hitResult.getBlockPos().equals((Object)target.pos));
    }

    private boolean isAnotherMobInteractingWithTarget(TransportItemTarget target, Level level) {
        return this.getConnectedTargets(target, level).anyMatch(this.shouldQueueForTarget);
    }

    private static boolean isPickingUpItems(PathfinderMob mob) {
        return mob.getMainHandItem().isEmpty();
    }

    private static boolean matchesGettingItemsRequirement(Container container) {
        return !container.isEmpty();
    }

    private static boolean matchesLeavingItemsRequirement(PathfinderMob mob, Container container) {
        return container.isEmpty() || TransportItemsBetweenContainers.hasItemMatchingHandItem(mob, container);
    }

    private static boolean hasItemMatchingHandItem(PathfinderMob mob, Container container) {
        ItemStack handItem = mob.getMainHandItem();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack containerItem = container.getItem(i);
            if (!ItemStack.isSameItem((ItemStack)containerItem, (ItemStack)handItem)) continue;
            return true;
        }
        return false;
    }

    private void pickUpItems(PathfinderMob mob, Container container) {
        mob.setItemSlot(EquipmentSlot.MAINHAND, TransportItemsBetweenContainers.pickupItemFromContainer(container));
        mob.setGuaranteedDrop(EquipmentSlot.MAINHAND);
        container.setChanged();
        this.clearMemoriesAfterMatchingTargetFound(mob);
    }

    private void putDownItem(PathfinderMob mob, Container container) {
        ItemStack remainingItems = TransportItemsBetweenContainers.addItemsToContainer(mob, container);
        container.setChanged();
        mob.setItemSlot(EquipmentSlot.MAINHAND, remainingItems);
        if (remainingItems.isEmpty()) {
            this.clearMemoriesAfterMatchingTargetFound(mob);
        } else {
            this.stopTargetingCurrentTarget(mob);
        }
    }

    private static ItemStack pickupItemFromContainer(Container container) {
        for (int slot = 0; slot < container.getContainerSize(); ++slot) {
            ItemStack itemStack = container.getItem(slot);
            if (itemStack.isEmpty()) continue;
            int count = Math.min(itemStack.getCount(), 16);
            return container.removeItem(slot, count);
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack addItemsToContainer(PathfinderMob mob, Container container) {
        ItemStack handItem = mob.getMainHandItem();
        for (int slot = 0; slot < container.getContainerSize(); ++slot) {
            ItemStack containerItem = container.getItem(slot);
            if (containerItem.isEmpty()) {
                container.setItem(slot, handItem);
                return ItemStack.EMPTY;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)containerItem, (ItemStack)handItem) || containerItem.getCount() >= containerItem.getMaxStackSize()) continue;
            int spaceLeft = containerItem.getMaxStackSize() - containerItem.getCount();
            int toAdd = Math.min(spaceLeft, handItem.getCount());
            containerItem.setCount(containerItem.getCount() + toAdd);
            handItem.setCount(handItem.getCount() - toAdd);
            container.setItem(slot, containerItem);
            if (!handItem.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return handItem;
    }

    protected void stopTargetingCurrentTarget(PathfinderMob mob) {
        this.ticksSinceReachingTarget = 0;
        this.target = null;
        mob.getNavigation().stop();
        mob.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    protected void clearMemoriesAfterMatchingTargetFound(PathfinderMob mob) {
        this.stopTargetingCurrentTarget(mob);
        mob.getBrain().eraseMemory((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get());
        mob.getBrain().eraseMemory((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get());
    }

    private void enterCooldownAfterNoMatchingTargetFound(PathfinderMob mob) {
        this.stopTargetingCurrentTarget(mob);
        mob.getBrain().setMemory((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get(), (Object)140);
        mob.getBrain().eraseMemory((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get());
        mob.getBrain().eraseMemory((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get());
    }

    protected void stop(ServerLevel level, PathfinderMob mob, long gameTime) {
        this.onStartTravelling(mob);
    }

    private void stopInPlace(PathfinderMob mob) {
        mob.getNavigation().stop();
        mob.setXxa(0.0f);
        mob.setYya(0.0f);
        mob.setSpeed(0.0f);
        mob.setDeltaMovement(0.0, mob.getDeltaMovement().y, 0.0);
    }

    public record TransportItemTarget(BlockPos pos, Container container, BlockEntity blockEntity, BlockState state) {
        @Nullable
        public static TransportItemTarget tryCreatePossibleTarget(BlockEntity blockEntity, Level level) {
            BlockPos blockpos = blockEntity.getBlockPos();
            BlockState blockstate = blockEntity.getBlockState();
            Container container = TransportItemTarget.getBlockEntityContainer(blockEntity, blockstate, level, blockpos);
            return container != null ? new TransportItemTarget(blockpos, container, blockEntity, blockstate) : null;
        }

        @Nullable
        public static TransportItemTarget tryCreatePossibleTarget(BlockPos pos, Level level) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            return blockentity == null ? null : TransportItemTarget.tryCreatePossibleTarget(blockentity, level);
        }

        @Nullable
        private static Container getBlockEntityContainer(BlockEntity blockEntity, BlockState state, Level level, BlockPos pos) {
            Container container;
            Block block = state.getBlock();
            if (block instanceof ChestBlock) {
                ChestBlock chestblock = (ChestBlock)block;
                return ChestBlock.getContainer((ChestBlock)chestblock, (BlockState)state, (Level)level, (BlockPos)pos, (boolean)false);
            }
            return blockEntity instanceof Container ? (container = (Container)blockEntity) : null;
        }
    }

    public static enum TransportItemState {
        TRAVELLING,
        QUEUING,
        INTERACTING;

    }

    public static enum ContainerInteractionState {
        PICKUP_ITEM,
        PICKUP_NO_ITEM,
        PLACE_ITEM,
        PLACE_NO_ITEM;

    }

    @FunctionalInterface
    public static interface OnTargetReachedInteraction
    extends TriConsumer<PathfinderMob, TransportItemTarget, Integer> {
    }
}

