/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.client.model;

import com.github.smallinger.coppergolemlegacy.client.animation.CopperGolemAnimation;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemEntity;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;

public class CopperGolemModel
extends HierarchicalModel<CopperGolemEntity>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("coppergolemlegacy", "copper_golem"), "main");
    public static final ModelLayerLocation STATUE_STANDING = new ModelLayerLocation(new ResourceLocation("coppergolemlegacy", "copper_golem_statue_standing"), "main");
    public static final ModelLayerLocation STATUE_RUNNING = new ModelLayerLocation(new ResourceLocation("coppergolemlegacy", "copper_golem_statue_running"), "main");
    public static final ModelLayerLocation STATUE_SITTING = new ModelLayerLocation(new ResourceLocation("coppergolemlegacy", "copper_golem_statue_sitting"), "main");
    public static final ModelLayerLocation STATUE_STAR = new ModelLayerLocation(new ResourceLocation("coppergolemlegacy", "copper_golem_statue_star"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final AnimationDefinition walkAnimation;
    private final AnimationDefinition walkWithItemAnimation;
    private final AnimationDefinition idleAnimation;
    private final AnimationDefinition interactionGetItem;
    private final AnimationDefinition interactionGetNoItem;
    private final AnimationDefinition interactionDropItem;
    private final AnimationDefinition interactionDropNoItem;
    private final AnimationDefinition pressButton;

    public CopperGolemModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
        this.walkAnimation = CopperGolemAnimation.COPPER_GOLEM_WALK;
        this.walkWithItemAnimation = CopperGolemAnimation.COPPER_GOLEM_WALK_ITEM;
        this.idleAnimation = CopperGolemAnimation.COPPER_GOLEM_IDLE;
        this.interactionGetItem = CopperGolemAnimation.COPPER_GOLEM_CHEST_INTERACTION_NOITEM_GET;
        this.interactionGetNoItem = CopperGolemAnimation.COPPER_GOLEM_CHEST_INTERACTION_NOITEM_NOGET;
        this.interactionDropItem = CopperGolemAnimation.COPPER_GOLEM_CHEST_INTERACTION_ITEM_DROP;
        this.interactionDropNoItem = CopperGolemAnimation.COPPER_GOLEM_CHEST_INTERACTION_ITEM_NODROP;
        this.pressButton = CopperGolemAnimation.COPPER_GOLEM_PRESS_BUTTON;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -5.0f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.015f)).m_171514_(56, 0).m_171488_(-1.0f, -2.0f, -6.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(37, 8).m_171488_(-1.0f, -9.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).m_171514_(37, 0).m_171488_(-2.0f, -13.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(-3.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-6.0f, (float)0.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(50, 16).m_171488_(0.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-6.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-4.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 27).m_171488_(0.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createStandingStatueBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -5.0f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.015f)).m_171514_(56, 0).m_171488_(-1.0f, -2.0f, -6.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(37, 8).m_171488_(-1.0f, -9.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).m_171514_(37, 0).m_171488_(-2.0f, -13.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(-3.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-6.0f, (float)0.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(50, 16).m_171488_(0.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-6.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-4.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 27).m_171488_(0.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createRunningPoseBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.064f, (float)-5.0f, (float)0.0f));
        body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-4.02f, -6.116f, -3.5f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.1f, (float)0.1f, (float)0.7f, (float)0.1204f, (float)-0.0064f, (float)-0.0779f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.1f, -5.0f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(56, 0).m_171488_(-1.02f, -2.1f, -6.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(37, 8).m_171488_(-1.02f, -9.1f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).m_171514_(37, 0).m_171488_(-2.0f, -13.1f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)), PartPose.m_171419_((float)0.7f, (float)-5.6f, (float)-1.8f));
        PartDefinition rightArm = body.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-6.0f, (float)0.0f));
        rightArm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(-3.052f, -1.11f, -2.036f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.7f, (float)-0.248f, (float)-1.62f, (float)1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-6.0f, (float)0.0f));
        leftArm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(50, 16).m_171488_(0.032f, -1.1f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.732f, (float)0.0f, (float)0.0f, (float)-0.8715f, (float)-0.0535f, (float)-0.0449f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.064f, (float)-5.0f, (float)0.0f));
        rightLeg.m_171599_("right_leg_r1", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-1.856f, -0.1f, -1.09f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.048f, (float)0.0f, (float)-0.9f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.936f, (float)-5.0f, (float)0.0f));
        leftLeg.m_171599_("left_leg_r1", CubeListBuilder.m_171558_().m_171514_(16, 27).m_171488_(-2.088f, -0.1f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSittingPoseBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(3, 19).m_171488_(-3.0f, -4.0f, -4.525f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 15).m_171488_(-4.0f, -3.0f, -3.525f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)2.325f));
        body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(3, 18).m_171488_(-4.0f, -3.0f, -2.2f, 8.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-4.325f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(37, 8).m_171488_(-1.0f, -7.0f, -3.3f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).m_171514_(37, 0).m_171488_(-2.0f, -11.0f, -4.3f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)).m_171514_(0, 0).m_171488_(-4.0f, -3.0f, -7.325f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(56, 0).m_171488_(-1.0f, 0.0f, -8.325f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-0.2f));
        PartDefinition rightArm = body.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-4.0f, (float)-5.6f, (float)-1.8f, (float)0.4363f, (float)0.0f, (float)0.0f));
        rightArm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(-3.075f, -0.9733f, -1.9966f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0893f, (float)0.1198f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)4.0f, (float)-5.6f, (float)-1.7f, (float)0.4363f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(50, 16).m_171488_(0.075f, -1.0443f, -1.8997f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.0015f, (float)-0.0808f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.1f, (float)-2.1f, (float)-2.075f));
        rightLeg.m_171599_("right_leg_r1", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-2.0f, 0.975f, 0.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.05f, (float)-1.9f, (float)1.075f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)-2.0f, (float)-2.075f));
        leftLeg.m_171599_("left_leg_r1", CubeListBuilder.m_171558_().m_171514_(16, 27).m_171488_(-2.0f, 0.975f, 0.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.05f, (float)-2.0f, (float)1.075f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createStarPoseBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -5.0f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(56, 0).m_171488_(-1.0f, -2.0f, -6.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(37, 8).m_171488_(-1.0f, -9.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).m_171514_(37, 0).m_171488_(-2.0f, -13.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-6.0f, (float)0.0f));
        rightArm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(-1.5f, -5.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.9199f));
        PartDefinition leftArm = body.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-6.0f, (float)0.0f));
        leftArm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(50, 16).m_171488_(-1.5f, -5.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.9199f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)-5.0f, (float)0.0f));
        rightLeg.m_171599_("right_leg_r1", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-2.0f, -2.5f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.35f, (float)2.0f, (float)0.01f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-5.0f, (float)0.0f));
        leftLeg.m_171599_("left_leg_r1", CubeListBuilder.m_171558_().m_171514_(16, 27).m_171488_(-2.0f, -2.5f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.65f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CopperGolemEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasItems;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        CopperGolemState state = entity.getState();
        boolean bl = hasItems = !entity.m_21205_().m_41619_();
        if (limbSwingAmount > 0.0f && state != CopperGolemState.PRESSING_BUTTON) {
            if (hasItems) {
                this.m_267799_(this.walkWithItemAnimation, limbSwing, limbSwingAmount, 2.0f, 2.5f);
                this.poseHeldItemArmsIfStill();
            } else {
                this.m_267799_(this.walkAnimation, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            }
        }
        if (state == CopperGolemState.IDLE) {
            this.m_233381_(entity.idleAnimationState, this.idleAnimation, ageInTicks);
        }
        switch (state) {
            case GETTING_ITEM: {
                this.m_233381_(entity.interactionGetItemAnimationState, this.interactionGetItem, ageInTicks);
                break;
            }
            case GETTING_NO_ITEM: {
                this.m_233381_(entity.interactionGetNoItemAnimationState, this.interactionGetNoItem, ageInTicks);
                break;
            }
            case DROPPING_ITEM: {
                this.m_233381_(entity.interactionDropItemAnimationState, this.interactionDropItem, ageInTicks);
                break;
            }
            case DROPPING_NO_ITEM: {
                this.m_233381_(entity.interactionDropNoItemAnimationState, this.interactionDropNoItem, ageInTicks);
                break;
            }
            case PRESSING_BUTTON: {
                this.m_233381_(entity.pressingButtonAnimationState, this.pressButton, ageInTicks);
                break;
            }
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        ModelPart armPart = arm == HumanoidArm.RIGHT ? this.rightArm : this.leftArm;
        armPart.m_104299_(poseStack);
        CopperGolemState state = CopperGolemState.IDLE;
        if (state == CopperGolemState.IDLE) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(arm == HumanoidArm.RIGHT ? -90.0f : 90.0f));
            poseStack.m_252880_(0.0f, 0.0f, 0.125f);
        } else {
            poseStack.m_85841_(0.55f, 0.55f, 0.55f);
            poseStack.m_252880_(-0.125f, 0.3125f, -0.1875f);
        }
    }

    private void poseHeldItemArmsIfStill() {
        this.rightArm.f_104203_ = Math.min(this.rightArm.f_104203_, -0.87266463f);
        this.leftArm.f_104203_ = Math.min(this.leftArm.f_104203_, -0.87266463f);
        this.rightArm.f_104204_ = Math.min(this.rightArm.f_104204_, -0.1134464f);
        this.leftArm.f_104204_ = Math.max(this.leftArm.f_104204_, 0.1134464f);
        this.rightArm.f_104205_ = Math.min(this.rightArm.f_104205_, -0.064577185f);
        this.leftArm.f_104205_ = Math.max(this.leftArm.f_104205_, 0.064577185f);
    }
}

