/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.entity.ai;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacyConfig;
import com.github.smallinger.coppergolemlegacy.ModMemoryTypes;
import com.github.smallinger.coppergolemlegacy.ModSounds;
import com.github.smallinger.coppergolemlegacy.ModTags;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemEntity;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemState;
import com.github.smallinger.coppergolemlegacy.entity.ai.behavior.InteractWithDoor;
import com.github.smallinger.coppergolemlegacy.entity.ai.behavior.PressRandomCopperButton;
import com.github.smallinger.coppergolemlegacy.entity.ai.behavior.TransportItemsBetweenContainers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;

public class CopperGolemAi {
    private static final ImmutableList<SensorType<? extends Sensor<? super CopperGolemEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_217768_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_26379_, (Object)((MemoryModuleType)ModMemoryTypes.GAZE_COOLDOWN_TICKS.get()), (Object)((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get()), (Object[])new MemoryModuleType[]{(MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get(), (MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get(), (MemoryModuleType)ModMemoryTypes.IS_PRESSING_BUTTON.get()});

    public static Brain.Provider<CopperGolemEntity> brainProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<CopperGolemEntity> makeBrain(Brain<CopperGolemEntity> brain) {
        CopperGolemAi.initCoreActivity(brain);
        CopperGolemAi.initIdleActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<CopperGolemEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new AnimalPanic(1.5f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), InteractWithDoor.create(), (Object)new CountDownCooldownTicks((MemoryModuleType)ModMemoryTypes.GAZE_COOLDOWN_TICKS.get()), (Object)new CountDownCooldownTicks((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get())));
    }

    private static void initIdleActivity(Brain<CopperGolemEntity> brain) {
        ImmutableList.Builder behaviorsBuilder = ImmutableList.builder();
        behaviorsBuilder.add((Object)Pair.of((Object)0, (Object)((Object)new TransportItemsBetweenContainers(1.0f, state -> state.m_204336_(ModTags.Blocks.COPPER_CHESTS), state -> state.m_60713_(Blocks.f_50087_) || state.m_60713_(Blocks.f_50325_), 32, 8, CopperGolemAi.getTargetReachedInteractions(), CopperGolemAi.onTravelling(), CopperGolemAi.shouldQueueForTarget()))));
        if (((Boolean)CopperGolemLegacyConfig.GOLEM_PRESSES_BUTTONS.get()).booleanValue()) {
            behaviorsBuilder.add((Object)Pair.of((Object)1, (Object)((Object)new PressRandomCopperButton(1.0f, 16, 4, 150))));
        }
        behaviorsBuilder.add((Object)Pair.of((Object)2, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)40, (int)80))));
        behaviorsBuilder.add((Object)Pair.of((Object)3, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get()), (Object)MemoryStatus.VALUE_PRESENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257960_((float)1.0f, (int)2, (int)2), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))));
        brain.m_21900_(Activity.f_37979_, behaviorsBuilder.build());
    }

    private static Map<TransportItemsBetweenContainers.ContainerInteractionState, TransportItemsBetweenContainers.OnTargetReachedInteraction> getTargetReachedInteractions() {
        return Map.of(TransportItemsBetweenContainers.ContainerInteractionState.PICKUP_ITEM, CopperGolemAi.onReachedTargetInteraction(CopperGolemState.GETTING_ITEM, (SoundEvent)ModSounds.COPPER_GOLEM_ITEM_GET.get()), TransportItemsBetweenContainers.ContainerInteractionState.PICKUP_NO_ITEM, CopperGolemAi.onReachedTargetInteraction(CopperGolemState.GETTING_NO_ITEM, (SoundEvent)ModSounds.COPPER_GOLEM_ITEM_NO_GET.get()), TransportItemsBetweenContainers.ContainerInteractionState.PLACE_ITEM, CopperGolemAi.onReachedTargetInteraction(CopperGolemState.DROPPING_ITEM, (SoundEvent)ModSounds.COPPER_GOLEM_ITEM_DROP.get()), TransportItemsBetweenContainers.ContainerInteractionState.PLACE_NO_ITEM, CopperGolemAi.onReachedTargetInteraction(CopperGolemState.DROPPING_NO_ITEM, (SoundEvent)ModSounds.COPPER_GOLEM_ITEM_NO_DROP.get()));
    }

    private static TransportItemsBetweenContainers.OnTargetReachedInteraction onReachedTargetInteraction(CopperGolemState state, @Nullable SoundEvent sound) {
        return (mob, target, tick) -> {
            if (mob instanceof CopperGolemEntity) {
                CopperGolemEntity copperGolem = (CopperGolemEntity)mob;
                if (tick == 1) {
                    CopperGolemAi.playChestSound(copperGolem, target.pos(), true);
                    copperGolem.setOpenedChestPos(target.pos());
                    copperGolem.setState(state);
                }
                if (tick == 9 && sound != null) {
                    copperGolem.m_5496_(sound, 1.0f, 1.0f);
                }
                if (tick == 60) {
                    CopperGolemAi.playChestSound(copperGolem, target.pos(), false);
                    copperGolem.clearOpenedChestPos();
                }
            }
        };
    }

    private static void playChestSound(CopperGolemEntity golem, BlockPos pos, boolean open) {
        Level level = golem.m_9236_();
        SoundEvent soundEvent = level.m_8055_(pos).m_204336_(ModTags.Blocks.COPPER_CHESTS) ? (open ? (SoundEvent)ModSounds.COPPER_CHEST_OPEN.get() : (SoundEvent)ModSounds.COPPER_CHEST_CLOSE.get()) : (open ? SoundEvents.f_11749_ : SoundEvents.f_11747_);
        level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChestBlockEntity) {
            level.m_7696_(pos, level.m_8055_(pos).m_60734_(), 1, open ? 1 : 0);
        }
        level.m_142346_((Entity)golem, open ? GameEvent.f_157803_ : GameEvent.f_157802_, pos);
    }

    private static Consumer<PathfinderMob> onTravelling() {
        return mob -> {
            if (mob instanceof CopperGolemEntity) {
                CopperGolemEntity copperGolem = (CopperGolemEntity)mob;
                copperGolem.clearOpenedChestPos();
                copperGolem.setState(CopperGolemState.IDLE);
            }
        };
    }

    private static Predicate<TransportItemsBetweenContainers.TransportItemTarget> shouldQueueForTarget() {
        return target -> false;
    }

    public static void updateActivity(CopperGolemEntity golem) {
        golem.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37979_));
    }
}

