/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.entity.ai.behavior;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class InteractWithDoor {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 10;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 3.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;

    public static BehaviorControl<LivingEntity> create() {
        MutableObject lastPathNode = new MutableObject(null);
        MutableInt cooldown = new MutableInt(0);
        return BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257495_(MemoryModuleType.f_26377_), (App)instance.m_257492_(MemoryModuleType.f_26379_), (App)instance.m_257492_(MemoryModuleType.f_148204_)).apply((Applicative)instance, (pathMemory, doorsToCloseMemory, nearestEntitiesMemory) -> (level, entity, gameTime) -> {
            Path path = (Path)instance.m_258051_(pathMemory);
            Optional<Set<GlobalPos>> doorsToClose = instance.m_257828_(doorsToCloseMemory);
            if (!path.m_77387_() && !path.m_77392_()) {
                DoorBlock door;
                BlockPos nextPos;
                BlockState nextState;
                if (Objects.equals(lastPathNode.getValue(), path.m_77401_())) {
                    cooldown.setValue(10);
                } else if (cooldown.decrementAndGet() > 0) {
                    return false;
                }
                lastPathNode.setValue((Object)path.m_77401_());
                Node previousNode = path.m_77402_();
                Node nextNode = path.m_77401_();
                BlockPos previousPos = previousNode.m_77288_();
                BlockState previousState = level.m_8055_(previousPos);
                if (previousState.m_204336_(BlockTags.f_13095_) && previousState.m_60734_() instanceof DoorBlock) {
                    DoorBlock door2 = (DoorBlock)previousState.m_60734_();
                    if (!door2.m_52815_(previousState)) {
                        door2.m_153165_((Entity)entity, (Level)level, previousState, previousPos, true);
                    }
                    doorsToClose = InteractWithDoor.rememberDoorToClose(doorsToCloseMemory, doorsToClose, level, previousPos);
                }
                if ((nextState = level.m_8055_(nextPos = nextNode.m_77288_())).m_204336_(BlockTags.f_13095_) && nextState.m_60734_() instanceof DoorBlock && !(door = (DoorBlock)nextState.m_60734_()).m_52815_(nextState)) {
                    door.m_153165_((Entity)entity, (Level)level, nextState, nextPos, true);
                    doorsToClose = InteractWithDoor.rememberDoorToClose(doorsToCloseMemory, doorsToClose, level, nextPos);
                }
                doorsToClose.ifPresent(doors -> InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(level, entity, previousNode, nextNode, doors, instance.m_257828_(nearestEntitiesMemory)));
                return true;
            }
            return false;
        }));
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(ServerLevel level, LivingEntity entity, @Nullable Node previous, @Nullable Node next, Set<GlobalPos> doorPositions, Optional<List<LivingEntity>> nearestLivingEntities) {
        Iterator<GlobalPos> iterator = doorPositions.iterator();
        while (iterator.hasNext()) {
            GlobalPos doorPos = iterator.next();
            BlockPos blockPos = doorPos.m_122646_();
            if (previous != null && previous.m_77288_().equals((Object)blockPos) || next != null && next.m_77288_().equals((Object)blockPos)) continue;
            if (InteractWithDoor.isDoorTooFarAway(level, entity, doorPos)) {
                iterator.remove();
                continue;
            }
            BlockState blockState = level.m_8055_(blockPos);
            if (!blockState.m_204336_(BlockTags.f_13095_) || !(blockState.m_60734_() instanceof DoorBlock)) {
                iterator.remove();
                continue;
            }
            DoorBlock door = (DoorBlock)blockState.m_60734_();
            if (!door.m_52815_(blockState)) {
                iterator.remove();
                continue;
            }
            if (InteractWithDoor.areOtherMobsComingThroughDoor(entity, blockPos, nearestLivingEntities)) {
                iterator.remove();
                continue;
            }
            door.m_153165_((Entity)entity, (Level)level, blockState, blockPos, false);
            iterator.remove();
        }
    }

    private static boolean areOtherMobsComingThroughDoor(LivingEntity entity, BlockPos doorPos, Optional<List<LivingEntity>> nearestLivingEntities) {
        if (nearestLivingEntities.isEmpty()) {
            return false;
        }
        return nearestLivingEntities.get().stream().filter(mob -> mob.m_6095_() == entity.m_6095_()).filter(mob -> doorPos.m_203195_((Position)mob.m_20182_(), 2.0)).anyMatch(mob -> InteractWithDoor.isMobComingThroughDoor(mob.m_6274_(), doorPos));
    }

    private static boolean isMobComingThroughDoor(Brain<?> brain, BlockPos doorPos) {
        if (!brain.m_21874_(MemoryModuleType.f_26377_)) {
            return false;
        }
        Path path = (Path)brain.m_21952_(MemoryModuleType.f_26377_).get();
        if (path.m_77392_()) {
            return false;
        }
        Node previousNode = path.m_77402_();
        if (previousNode == null) {
            return false;
        }
        Node nextNode = path.m_77401_();
        return doorPos.equals((Object)previousNode.m_77288_()) || doorPos.equals((Object)nextNode.m_77288_());
    }

    private static boolean isDoorTooFarAway(ServerLevel level, LivingEntity entity, GlobalPos doorPos) {
        return doorPos.m_122640_() != level.m_46472_() || !doorPos.m_122646_().m_203195_((Position)entity.m_20182_(), 3.0);
    }

    private static Optional<Set<GlobalPos>> rememberDoorToClose(MemoryAccessor<?, Set<GlobalPos>> doorsToCloseMemory, Optional<Set<GlobalPos>> doorPositions, ServerLevel level, BlockPos doorPos) {
        GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)doorPos);
        return Optional.of(doorPositions.map(doors -> {
            doors.add(globalPos);
            return doors;
        }).orElseGet(() -> {
            HashSet newDoors = Sets.newHashSet((Object[])new GlobalPos[]{globalPos});
            doorsToCloseMemory.m_257512_((Object)newDoors);
            return newDoors;
        }));
    }
}

