/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.events;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModMemoryTypes;
import com.github.smallinger.coppergolemlegacy.ModTags;
import com.github.smallinger.coppergolemlegacy.block.CopperChestBlock;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="coppergolemlegacy")
public class CopperGolemSpawnHandler {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Level level = (Level)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState placedState = event.getPlacedBlock();
        if (placedState.m_60713_(Blocks.f_50143_) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction playerDirection = Direction.NORTH;
            if (event.getEntity() != null) {
                playerDirection = Direction.m_122364_((double)event.getEntity().m_146908_());
            }
            CopperGolemSpawnHandler.trySpawnCopperGolem(serverLevel, pos, playerDirection);
        }
    }

    private static void trySpawnCopperGolem(ServerLevel level, BlockPos pumpkinPos, Direction playerDirection) {
        BlockPos copperPos = pumpkinPos.m_7495_();
        BlockState copperState = level.m_8055_(copperPos);
        if (copperState.m_204336_(ModTags.Blocks.COPPER)) {
            Direction direction = playerDirection.m_122424_();
            level.m_7731_(pumpkinPos, Blocks.f_50016_.m_49966_(), 2);
            Block copperBlock = copperState.m_60734_();
            BlockState chestState = CopperChestBlock.getFromCopperBlock(copperBlock, direction, (Level)level, copperPos);
            level.m_7731_(copperPos, chestState, 2);
            level.m_46796_(2001, pumpkinPos, Block.m_49956_((BlockState)Blocks.f_50143_.m_49966_()));
            CopperGolemEntity copperGolem = (CopperGolemEntity)((EntityType)CopperGolemLegacy.COPPER_GOLEM.get()).m_20615_((Level)level);
            if (copperGolem != null) {
                float yaw = direction.m_122435_();
                copperGolem.m_7678_((double)copperPos.m_123341_() + 0.5, (double)copperPos.m_123342_() + 1.0, (double)copperPos.m_123343_() + 0.5, yaw, 0.0f);
                copperGolem.m_146922_(yaw);
                copperGolem.f_19859_ = yaw;
                copperGolem.m_5618_(yaw);
                copperGolem.f_20884_ = yaw;
                copperGolem.m_5616_(yaw);
                copperGolem.f_20886_ = yaw;
                WeatheringCopper.WeatherState weatherState = CopperGolemSpawnHandler.getWeatherStateFromBlock(copperState.m_60734_());
                copperGolem.setWeatherState(weatherState);
                copperGolem.m_6274_().m_21879_((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get(), (Object)140);
                level.m_7967_((Entity)copperGolem);
                for (ServerPlayer serverPlayer : level.m_45976_(ServerPlayer.class, copperGolem.m_20191_().m_82400_(5.0))) {
                }
                level.m_46672_(copperPos, chestState.m_60734_());
                level.m_46672_(pumpkinPos, Blocks.f_50016_);
            }
        }
    }

    private static WeatheringCopper.WeatherState getWeatherStateFromBlock(Block block) {
        if (block instanceof WeatheringCopper) {
            WeatheringCopper weatheringCopper = (WeatheringCopper)block;
            return (WeatheringCopper.WeatherState)weatheringCopper.m_142297_();
        }
        if (block == Blocks.f_152571_) {
            return WeatheringCopper.WeatherState.UNAFFECTED;
        }
        if (block == Blocks.f_152573_) {
            return WeatheringCopper.WeatherState.EXPOSED;
        }
        if (block == Blocks.f_152572_) {
            return WeatheringCopper.WeatherState.WEATHERED;
        }
        if (block == Blocks.f_152574_) {
            return WeatheringCopper.WeatherState.OXIDIZED;
        }
        return WeatheringCopper.WeatherState.UNAFFECTED;
    }
}

