/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.dynamicborder;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.samxel.dynamicborder.BorderCommand;
import com.samxel.dynamicborder.Config;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.slf4j.Logger;

@Mod(value="dynamicborder")
public class DynamicBorder {
    public static final String MODID = "dynamicborder";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final double MAX_BORDER_SIZE = 5.9999968E7;
    private static MinecraftServer serverInstance;
    private static volatile boolean paused;
    private int tickCounter = 0;
    private boolean initialized = false;

    public DynamicBorder(ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static void stopAndFixSizeRounded() {
        ServerLevel nether;
        if (serverInstance == null) {
            return;
        }
        ServerLevel overworld = serverInstance.overworld();
        if (overworld != null) {
            WorldBorder border = overworld.getWorldBorder();
            double fixed = Math.ceil(border.getSize());
            border.setSize(fixed);
        }
        if ((nether = serverInstance.getLevel(Level.NETHER)) != null) {
            WorldBorder netherBorder = nether.getWorldBorder();
            double fixedNether = Math.ceil(netherBorder.getSize());
            netherBorder.setSize(fixedNether);
        }
        LOGGER.info("[DynamicBorder] Lerp stopped and size fixed (rounded up).");
    }

    public static boolean isPaused() {
        return paused;
    }

    public static void setPaused(boolean value) {
        paused = value;
        if (paused) {
            DynamicBorder.stopAndFixSizeRounded();
        } else {
            LOGGER.info("[DynamicBorder] Resumed.");
        }
    }

    public static void applyBorderUpdate() {
        if (serverInstance == null) {
            return;
        }
        DynamicBorder.applyBorderUpdate(serverInstance);
    }

    private static void applyBorderUpdate(MinecraftServer server) {
        if (paused) {
            return;
        }
        int players = server.getPlayerList().getPlayerCount();
        WorldBorder border = server.overworld().getWorldBorder();
        double current = border.getSize();
        double baseChange = ((Integer)Config.BLOCKS_PER_INTERVAL.get()).intValue();
        double perPlayerChange = ((Integer)Config.BLOCKS_PER_INTERVAL_PER_PLAYER.get()).intValue();
        boolean reversed = (Boolean)Config.REVERSED.get();
        double totalChange = (baseChange + perPlayerChange * (double)Math.max(0, players - 1)) * 2.0;
        double newSize = reversed ? Math.max(1.0, current - totalChange) : Math.min(5.9999968E7, current + totalChange);
        double durationSeconds = ((Integer)Config.SECONDS_INTERVAL.get()).intValue();
        long durationMillis = (long)(durationSeconds * 1000.0);
        if (newSize != current) {
            border.lerpSizeBetween(current, newSize, durationMillis);
            LOGGER.info("[DynamicBorder] {} border by {} blocks", (Object)(reversed ? "Shrunk" : "Expanded"), (Object)(totalChange / 2.0));
            ServerLevel nether = server.getLevel(Level.NETHER);
            if (nether != null) {
                WorldBorder netherBorder = nether.getWorldBorder();
                double netherCurrent = netherBorder.getSize();
                double netherNewSize = reversed ? Math.max(1.0, netherCurrent - totalChange / 8.0) : Math.min(5.9999968E7, netherCurrent + totalChange / 8.0);
                netherBorder.lerpSizeBetween(netherCurrent, netherNewSize, durationMillis);
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = serverInstance = event.getServer();
        WorldBorder border = server.overworld().getWorldBorder();
        double currentSize = border.getSize();
        double startSize = ((Integer)Config.START_SIZE.get()).intValue();
        ServerLevel world = server.overworld();
        BlockPos spawn = world.getLevelData().getRespawnData().pos();
        border.setCenter((double)spawn.getX() + 0.5, (double)spawn.getZ() + 0.5);
        if (Math.abs(currentSize - 5.9999968E7) < 1.0) {
            border.setSize(startSize);
            LOGGER.info("[DynamicBorder] World border initialized at spawn ({}, {}) with size: {}", new Object[]{spawn.getX(), spawn.getZ(), startSize});
        } else {
            LOGGER.info("[DynamicBorder] World border exists with size: {}", (Object)currentSize);
        }
        ServerLevel nether = server.getLevel(Level.NETHER);
        if (nether != null) {
            WorldBorder netherBorder = nether.getWorldBorder();
            netherBorder.setCenter((double)spawn.getX() / 8.0 + 0.5, (double)spawn.getZ() / 8.0 + 0.5);
            netherBorder.setSize(startSize / 8.0);
        }
        this.initialized = true;
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer srv = event.getEntity().level().getServer();
        if (srv == null) {
            return;
        }
        if (srv.getPlayerList().getPlayerCount() == 0 && !paused) {
            DynamicBorder.stopAndFixSizeRounded();
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        if (!this.initialized) {
            return;
        }
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        if (paused) {
            this.tickCounter = 0;
            return;
        }
        int players = server.getPlayerList().getPlayerCount();
        if (players == 0) {
            this.tickCounter = 0;
            DynamicBorder.stopAndFixSizeRounded();
            return;
        }
        ++this.tickCounter;
        int intervalTicks = (Integer)Config.SECONDS_INTERVAL.get() * 20;
        if (this.tickCounter < intervalTicks) {
            return;
        }
        this.tickCounter = 0;
        DynamicBorder.applyBorderUpdate(server);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        BorderCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    static {
        paused = false;
    }
}

