/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.entities;

import com.google.common.collect.Maps;
import com.zombie_cute.mc.bakingdelight.block.custom.FreezerBlock;
import com.zombie_cute.mc.bakingdelight.block.entities.ImplementedInventory;
import com.zombie_cute.mc.bakingdelight.block.entities.IsStateChange;
import com.zombie_cute.mc.bakingdelight.block.entities.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.recipe.FreezerRecipe;
import com.zombie_cute.mc.bakingdelight.screen.FreezerScreenHandler;
import com.zombie_cute.mc.bakingdelight.tag.ModTagKeys;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FreezerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
IsStateChange,
class_1278 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)20, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int INPUT_SLOT_3 = 2;
    private static final int ICE_SLOT = 3;
    private static final int OUTPUT_SLOT = 4;
    public static final String FREEZER_NAME = "display_name.bakingdelight.freezer_name";
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> FreezerBlockEntity.this.progress;
                case 1 -> FreezerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    FreezerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    FreezerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 400;
    private int coolTime = 0;

    public FreezerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.FREEZER_BLOCK_ENTITY, pos, state);
    }

    public void method_5435(class_1657 player) {
        player.method_5783(class_3417.field_15082, 1.0f, 1.0f);
    }

    public void method_5432(class_1657 player) {
        player.method_5783(class_3417.field_15131, 1.0f, 1.0f);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("freezer.progress", this.progress);
        nbt.method_10569("freezer.fuelTime", this.coolTime);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("freezer.progress");
        this.coolTime = nbt.method_10550("freezer.coolTime");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)FREEZER_NAME);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FreezerScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, FreezerBlockEntity entity) {
        if (world.field_9236) {
            return;
        }
        if (this.isCool()) {
            --this.coolTime;
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)FreezerBlock.HAS_ICE, (Comparable)Boolean.valueOf(true)));
        } else {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)FreezerBlock.HAS_ICE, (Comparable)Boolean.valueOf(false)));
        }
        if (FreezerBlockEntity.canUseAsIce(this.method_5438(3)) && this.coolTime == 0) {
            class_1799 ice = this.method_5438(3);
            this.coolTime = this.getCoolTime(ice);
            this.method_5434(3, 1);
        }
        if (this.isOutputSlotEmptyOrReceivable() && this.isCool()) {
            if (this.hasRecipe(entity)) {
                this.increaseCraftProgress();
                FreezerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.hasCraftingFinished()) {
                    this.craftItem(entity);
                    this.resetProgress();
                }
            } else if (this.method_5438(0).method_7909() == class_1802.field_8705) {
                this.increaseCraftProgress();
                FreezerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.hasCraftingFinished()) {
                    this.method_5447(4, new class_1799((class_1935)class_1802.field_8426, this.method_5438(4).method_7947() + 4));
                    this.method_5447(0, new class_1799((class_1935)class_1802.field_8550));
                    this.resetProgress();
                }
            } else if (this.method_5438(0).method_7909() == class_1802.field_8187) {
                this.increaseCraftProgress();
                FreezerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.hasCraftingFinished()) {
                    this.method_5447(4, new class_1799((class_1935)class_1802.field_8281, this.method_5438(4).method_7947() + 4));
                    this.method_5447(0, new class_1799((class_1935)class_1802.field_8550));
                    this.resetProgress();
                }
            } else if (this.coolTime != 0 && this.progress > 1) {
                this.progress -= 2;
            } else {
                this.resetProgress();
            }
        } else {
            if (this.coolTime != 0 && this.progress > 1) {
                this.progress -= 2;
            } else {
                this.resetProgress();
            }
            FreezerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public static Map<class_1792, Integer> createCoolTimeMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8426, 60);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8081, 580);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8178, 5500);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8246, 50);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, (class_1935)class_1802.field_8749, 30);
        FreezerBlockEntity.addIce((Map<class_1792, Integer>)map, ModTagKeys.COOL_ITEMS, 10);
        return map;
    }

    private static void addIce(Map<class_1792, Integer> coolTimes, class_6862<class_1792> tag, int coolTime) {
        for (class_6880 registryEntry : class_7923.field_41178.method_40286(tag)) {
            coolTimes.put((class_1792)registryEntry.comp_349(), coolTime);
        }
    }

    private static void addIce(Map<class_1792, Integer> coolTimes, class_1935 item, int coolTime) {
        class_1792 item2 = item.method_8389();
        coolTimes.put(item2, coolTime);
    }

    public static boolean canUseAsIce(class_1799 stack) {
        return FreezerBlockEntity.createCoolTimeMap().containsKey(stack.method_7909());
    }

    private int getCoolTime(class_1799 ice) {
        if (ice.method_7960()) {
            return 0;
        }
        class_1792 item = ice.method_7909();
        return FreezerBlockEntity.createCoolTimeMap().getOrDefault(item, 0);
    }

    private boolean isCool() {
        return this.coolTime > 0;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem(FreezerBlockEntity entity) {
        class_1277 inventory = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory.method_5447(i, entity.method_5438(i));
        }
        Optional match = entity.method_10997().method_8433().method_8132((class_3956)FreezerRecipe.Type.INSTANCE, (class_1263)inventory, entity.method_10997());
        this.method_5434(0, 1);
        this.method_5434(1, 1);
        this.method_5434(2, 1);
        this.method_5447(4, new class_1799((class_1935)((FreezerRecipe)match.get()).method_8110(null).method_7909(), this.method_5438(4).method_7947() + ((FreezerRecipe)match.get()).method_8110(null).method_7947()));
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftProgress() {
        ++this.progress;
    }

    private boolean hasRecipe(FreezerBlockEntity entity) {
        class_1277 inventory = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory.method_5447(i, entity.method_5438(i));
        }
        Optional match = entity.method_10997().method_8433().method_8132((class_3956)FreezerRecipe.Type.INSTANCE, (class_1263)inventory, entity.method_10997());
        return match.isPresent() && this.canInsertAmountIntoOutputSlot(((FreezerRecipe)match.get()).method_8110(null)) && this.canInsertItemIntoOutputSlot(((FreezerRecipe)match.get()).method_8110(entity.field_11863.method_30349()).method_7909());
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(4).method_7909() == item || this.method_5438(4).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(4).method_7947() + result.method_7947() <= this.method_5438(4).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(4).method_7960() || this.method_5438(4).method_7947() < this.method_5438(4).method_7914();
    }

    public boolean isCooling() {
        if (this.field_11863 == null) {
            return false;
        }
        return this.isCooling(this.field_11863, this.field_11867);
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.getItems().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir == class_2350.field_11036 && slot >= 5) {
            return true;
        }
        if (dir == class_2350.field_11043 && slot == 3) {
            return true;
        }
        if (dir == class_2350.field_11039 && slot == 0) {
            return true;
        }
        if (dir == class_2350.field_11035 && slot == 1) {
            return true;
        }
        return dir == class_2350.field_11034 && slot == 2;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return dir == class_2350.field_11033 && slot >= 4;
    }
}

