/*
 * Decompiled with CFR 0.152.
 */
package com.zombie_cute.mc.bakingdelight.block.entities;

import com.zombie_cute.mc.bakingdelight.block.custom.OvenBlock;
import com.zombie_cute.mc.bakingdelight.block.entities.ImplementedInventory;
import com.zombie_cute.mc.bakingdelight.block.entities.IsStateChange;
import com.zombie_cute.mc.bakingdelight.block.entities.ModBlockEntities;
import com.zombie_cute.mc.bakingdelight.item.ModItems;
import com.zombie_cute.mc.bakingdelight.recipe.OvenRecipe;
import com.zombie_cute.mc.bakingdelight.screen.OvenScreenHandler;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class OvenBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory,
IsStateChange,
class_1278 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int INPUT_SLOT_3 = 2;
    private static final int INPUT_SLOT_4 = 3;
    private static final int FUEL_SLOT = 4;
    private static final int OUTPUT_SLOT = 5;
    public static final String OVEN_NAME = "display_name.bakingdelight.oven_name";
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> OvenBlockEntity.this.progress;
                case 1 -> OvenBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    OvenBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    OvenBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 200;
    private int burnTime = 0;

    public OvenBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.OVEN_BLOCK_ENTITY, pos, state);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("oven.progress", this.progress);
        nbt.method_10569("oven.fuelTime", this.burnTime);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("oven.progress");
        this.burnTime = nbt.method_10550("oven.fuelTime");
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)OVEN_NAME);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new OvenScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, OvenBlockEntity entity) {
        if (world.field_9236) {
            return;
        }
        if (this.isFuelBurning()) {
            --this.burnTime;
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)OvenBlock.OVEN_BURNING, (Comparable)Boolean.valueOf(true)));
        } else {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)OvenBlock.OVEN_BURNING, (Comparable)Boolean.valueOf(false)));
        }
        if (OvenBlockEntity.canUseAsFuel(this.method_5438(4)) && this.burnTime == 0) {
            class_1799 fuel = this.method_5438(4);
            this.burnTime = this.getFuelTime(fuel);
            if (this.method_5438(4).method_7909() == class_1802.field_8187) {
                this.method_5447(4, class_1802.field_8550.method_7854());
            } else {
                this.method_5434(4, 1);
            }
        }
        if (this.isOutputSlotEmptyOrReceivable() && this.isFuelBurning()) {
            if (this.hasRecipe(entity)) {
                this.increaseCraftProgress();
                OvenBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.hasCraftingFinished()) {
                    this.craftItem(entity);
                    this.resetProgress();
                }
            } else if (this.method_5438(0) == class_1802.field_8103.method_7854() && this.method_5438(1) == class_1802.field_8103.method_7854() && this.method_5438(2) == class_1802.field_8103.method_7854() && this.method_5438(3) == class_1802.field_8103.method_7854()) {
                this.increaseCraftProgress();
                OvenBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.hasCraftingFinished()) {
                    this.method_5434(0, 1);
                    this.method_5434(1, 1);
                    this.method_5434(2, 1);
                    this.method_5434(3, 1);
                    this.method_5447(5, new class_1799((class_1935)ModItems.CHEESE, this.method_5438(5).method_7947() + 2));
                    this.resetProgress();
                }
            } else if (this.burnTime != 0 && this.progress > 1) {
                this.progress -= 2;
            } else {
                this.resetProgress();
            }
        } else {
            if (this.burnTime != 0 && this.progress > 1) {
                this.progress -= 2;
            } else {
                this.resetProgress();
            }
            OvenBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public static boolean canUseAsFuel(class_1799 stack) {
        return class_2609.method_11196().containsKey(stack.method_7909());
    }

    private int getFuelTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        class_1792 item = fuel.method_7909();
        return class_2609.method_11196().getOrDefault(item, 0) * 2;
    }

    private boolean isFuelBurning() {
        return this.burnTime > 0;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem(OvenBlockEntity entity) {
        class_1277 inventory = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory.method_5447(i, entity.method_5438(i));
        }
        Optional match = entity.method_10997().method_8433().method_8132((class_3956)OvenRecipe.Type.INSTANCE, (class_1263)inventory, entity.method_10997());
        this.method_5434(0, 1);
        this.method_5434(1, 1);
        this.method_5434(2, 1);
        this.method_5434(3, 1);
        this.method_5447(5, new class_1799((class_1935)((OvenRecipe)match.get()).method_8110(null).method_7909(), this.method_5438(5).method_7947() + ((OvenRecipe)match.get()).method_8110(null).method_7947()));
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftProgress() {
        ++this.progress;
    }

    private boolean hasRecipe(OvenBlockEntity entity) {
        class_1277 inventory = new class_1277(entity.method_5439());
        for (int i = 0; i < entity.method_5439(); ++i) {
            inventory.method_5447(i, entity.method_5438(i));
        }
        Optional match = entity.method_10997().method_8433().method_8132((class_3956)OvenRecipe.Type.INSTANCE, (class_1263)inventory, entity.method_10997());
        return match.isPresent() && this.canInsertAmountIntoOutputSlot(((OvenRecipe)match.get()).method_8110(null)) && this.canInsertItemIntoOutputSlot(((OvenRecipe)match.get()).method_8110(entity.field_11863.method_30349()).method_7909());
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(5).method_7909() == item || this.method_5438(5).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(5).method_7947() + result.method_7947() <= this.method_5438(5).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(5).method_7960() || this.method_5438(5).method_7947() < this.method_5438(5).method_7914();
    }

    public boolean isBurning() {
        if (this.field_11863 == null) {
            return false;
        }
        return this.isHeated(this.field_11863, this.field_11867);
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.getItems().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir == class_2350.field_11036 && slot == 4) {
            return true;
        }
        if (dir == class_2350.field_11034 && slot == 0) {
            return true;
        }
        if (dir == class_2350.field_11035 && slot == 1) {
            return true;
        }
        if (dir == class_2350.field_11039 && slot == 2) {
            return true;
        }
        return dir == class_2350.field_11043 && slot == 3;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (dir == class_2350.field_11033 && slot == 4) {
            return stack.method_31574(class_1802.field_8550);
        }
        return dir == class_2350.field_11033 && slot == 5;
    }
}

