/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.fabric.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.kittehmod.ceilands.fabric.entity.ModBoat;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_897;

public class CeilandsBoatRenderer
extends class_897<ModBoat> {
    private final Map<ModBoat.Type, Pair<class_2960, class_554>> boatResources;

    public CeilandsBoatRenderer(class_5617.class_5618 context, boolean isChest) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(ModBoat.Type.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, p_234575_ -> Pair.of((Object)new class_2960("ceilands", CeilandsBoatRenderer.getTextureLocation(p_234575_, isChest)), (Object)this.createBoatModel(context, (ModBoat.Type)((Object)p_234575_), isChest))));
    }

    private class_554 createBoatModel(class_5617.class_5618 context, ModBoat.Type boatType, boolean isChest) {
        class_5601 modellayerlocation = isChest ? CeilandsBoatRenderer.createChestBoatModelName(boatType) : CeilandsBoatRenderer.createBoatModelName(boatType);
        return new class_554(context.method_32167(modellayerlocation), isChest);
    }

    private static String getTextureLocation(ModBoat.Type boatType, boolean isChest) {
        return isChest ? "textures/entity/chest_boat/" + boatType.getName() + ".png" : "textures/entity/boat/" + boatType.getName() + ".png";
    }

    public void render(ModBoat entityIn, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        float f2;
        matrixStackIn.method_22903();
        matrixStackIn.method_22904(0.0, 0.375, 0.0);
        matrixStackIn.method_22907(class_1160.field_20705.method_23214(180.0f - entityYaw));
        float f = (float)entityIn.method_7533() - partialTicks;
        float f1 = entityIn.method_7554() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStackIn.method_22907(class_1160.field_20703.method_23214(class_3532.method_15374((float)f) * f * f1 / 10.0f * (float)entityIn.method_7543()));
        }
        if (!class_3532.method_15347((float)(f2 = entityIn.method_7547(partialTicks)), (float)0.0f)) {
            matrixStackIn.method_22907(new class_1158(new class_1160(1.0f, 0.0f, 1.0f), entityIn.method_7547(partialTicks), true));
        }
        Pair<class_2960, class_554> pair = this.getModelWithLocation(entityIn);
        class_2960 resourcelocation = (class_2960)pair.getFirst();
        class_554 boatmodel = (class_554)pair.getSecond();
        matrixStackIn.method_22905(-1.0f, -1.0f, 1.0f);
        matrixStackIn.method_22907(class_1160.field_20705.method_23214(90.0f));
        boatmodel.method_22952((class_1690)entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexconsumer = bufferIn.getBuffer(boatmodel.method_23500(resourcelocation));
        boatmodel.method_2828(matrixStackIn, vertexconsumer, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entityIn.method_5869()) {
            class_4588 vertexconsumer1 = bufferIn.getBuffer(class_1921.method_23589());
            boatmodel.method_22954().method_22698(matrixStackIn, vertexconsumer1, packedLightIn, class_4608.field_21444);
        }
        matrixStackIn.method_22909();
        super.method_3936((class_1297)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public class_2960 getTextureLocation(ModBoat entity) {
        switch (entity.getCeilandsBoatType()) {
            case CEILTRUNK: {
                return new class_2960("ceilands:textures/entity/boat/ceiltrunk.png");
            }
        }
        return new class_2960("ceilands:textures/entity/boat/luzawood.png");
    }

    public Pair<class_2960, class_554> getModelWithLocation(ModBoat boat) {
        return this.boatResources.get((Object)boat.getCeilandsBoatType());
    }

    private static class_5601 createLocation(String path, String p_171302_) {
        return new class_5601(new class_2960("minecraft", path), p_171302_);
    }

    public static class_5601 createBoatModelName(ModBoat.Type p_171290_) {
        return CeilandsBoatRenderer.createLocation("boat/oak", "main");
    }

    public static class_5601 createChestBoatModelName(ModBoat.Type p_233551_) {
        return CeilandsBoatRenderer.createLocation("chest_boat/oak", "main");
    }
}

