/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.fabric.util;

import com.kittehmod.ceilands.fabric.block.CeilandsPortalBlock;
import com.kittehmod.ceilands.fabric.registry.CeilandsBlocks;
import com.kittehmod.ceilands.fabric.registry.CeilandsDimension;
import com.kittehmod.ceilands.fabric.registry.CeilandsPOIType;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4538;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import org.jetbrains.annotations.Nullable;

public class CeilandsPortalHelper {
    protected final class_3218 level;

    public CeilandsPortalHelper(class_3218 level) {
        this.level = level;
    }

    public Optional<class_5459.class_5460> getExistingPortal(class_2338 pos) {
        class_4153 poiManager = this.level.method_19494();
        poiManager.method_22439((class_4538)this.level, pos, 64);
        Optional<class_4156> optional = poiManager.method_22383(poiType -> poiType.method_40225(CeilandsPOIType.CEILANDS_PORTAL), pos, 64, class_4153.class_4155.field_18489).sorted(Comparator.comparingDouble(poi -> poi.method_19141().method_10262((class_2382)pos)).thenComparingInt(poi -> poi.method_19141().method_10264())).filter(poi -> this.level.method_8320(poi.method_19141()).method_28498((class_2769)class_2741.field_12529)).findFirst();
        return optional.map(poi -> {
            class_2338 blockpos = poi.method_19141();
            this.level.method_14178().method_17297(class_3230.field_19280, new class_1923(blockpos), 3, (Object)blockpos);
            class_2680 blockstate = this.level.method_8320(blockpos);
            return class_5459.method_30574((class_2338)blockpos, (class_2350.class_2351)((class_2350.class_2351)blockstate.method_11654((class_2769)class_2741.field_12529)), (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, posIn -> this.level.method_8320(posIn) == blockstate);
        });
    }

    public Optional<class_5459.class_5460> makePortal(class_2338 pos, class_2350.class_2351 axis) {
        class_2350 direction = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        double d0 = -1.0;
        class_2338 blockpos = null;
        double d1 = -1.0;
        class_2338 blockpos1 = null;
        class_2784 worldborder = this.level.method_8621();
        int dimensionLogicalHeight = this.level.method_31605() - 1;
        class_2338.class_2339 mutablePos = pos.method_25503();
        for (class_2338.class_2339 blockpos$mutable1 : class_2338.method_30512((class_2338)pos, (int)16, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
            int j = Math.min(dimensionLogicalHeight, this.level.method_8624(class_2902.class_2903.field_13197, blockpos$mutable1.method_10263(), blockpos$mutable1.method_10260()));
            if (!worldborder.method_11952((class_2338)blockpos$mutable1) || !worldborder.method_11952((class_2338)blockpos$mutable1.method_10104(direction, 1))) continue;
            blockpos$mutable1.method_10104(direction.method_10153(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.method_33098(l);
                if (!this.level.method_22347((class_2338)blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && this.level.method_22347((class_2338)blockpos$mutable1.method_10098(class_2350.field_11033))) {
                    --l;
                }
                if (l + 4 > dimensionLogicalHeight || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.method_33098(l);
                if (!this.checkRegionForPlacement((class_2338)blockpos$mutable1, mutablePos, direction, 0)) continue;
                double d2 = pos.method_10262((class_2382)blockpos$mutable1);
                if (this.checkRegionForPlacement((class_2338)blockpos$mutable1, mutablePos, direction, -1) && this.checkRegionForPlacement((class_2338)blockpos$mutable1, mutablePos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.method_10062();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.method_10062();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new class_2338(pos.method_10263(), class_3532.method_15340((int)pos.method_10264(), (int)70, (int)(this.level.method_31605() - 10)), pos.method_10260()).method_10062();
            class_2350 direction1 = direction.method_10170();
            if (!worldborder.method_11952(blockpos)) {
                return Optional.empty();
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        class_2680 blockstate1 = i3 < 0 ? CeilandsBlocks.POLISHED_CEILINGNEOUS.method_9564() : class_2246.field_10124.method_9564();
                        mutablePos.method_25504((class_2382)blockpos, k2 * direction.method_10148() + l1 * direction1.method_10148(), i3, k2 * direction.method_10165() + l1 * direction1.method_10165());
                        this.level.method_8501((class_2338)mutablePos, blockstate1);
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                mutablePos.method_25504((class_2382)blockpos, k1 * direction.method_10148(), i2, k1 * direction.method_10165());
                this.level.method_8652((class_2338)mutablePos, CeilandsBlocks.POLISHED_CEILINGNEOUS.method_9564(), 3);
            }
        }
        class_2680 ceilandsPortal = (class_2680)CeilandsBlocks.CEILANDS_PORTAL.method_9564().method_11657(CeilandsPortalBlock.AXIS, (Comparable)axis);
        for (int j2 = 0; j2 < 2; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                mutablePos.method_25504((class_2382)blockpos, j2 * direction.method_10148(), l2, j2 * direction.method_10165());
                this.level.method_8652((class_2338)mutablePos, ceilandsPortal, 18);
            }
        }
        return Optional.of(new class_5459.class_5460(blockpos.method_10062(), 2, 3));
    }

    private boolean checkRegionForPlacement(class_2338 originalPos, class_2338.class_2339 offsetPos, class_2350 directionIn, int offsetScale) {
        class_2350 direction = directionIn.method_10170();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.method_25504((class_2382)originalPos, directionIn.method_10148() * i + direction.method_10148() * offsetScale, j, directionIn.method_10165() * i + direction.method_10165() * offsetScale);
                if (j < 0 && !this.level.method_8320((class_2338)offsetPos).method_26207().method_15799()) {
                    return false;
                }
                if (j < 0 || this.level.method_22347((class_2338)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public class_5454 getPortalInfo(class_1297 entity, class_3218 level, Function<class_3218, class_5454> defaultPortalInfo) {
        boolean destinationIsCeilands;
        boolean bl = destinationIsCeilands = level.method_27983() == CeilandsDimension.CEILANDS;
        if (entity.method_37908().method_27983() != CeilandsDimension.CEILANDS && !destinationIsCeilands) {
            return null;
        }
        class_2784 border = level.method_8621();
        double diff = class_2874.method_31109((class_2874)entity.method_37908().method_8597(), (class_2874)level.method_8597());
        class_2338 blockpos = border.method_39538(entity.method_23317() * diff, entity.method_23318(), entity.method_23321() * diff);
        return this.getOrMakePortal(entity, blockpos, border).map(result -> {
            class_243 vector3d;
            class_2350.class_2351 axis;
            class_2680 blockstate = entity.field_6002.method_8320(entity.field_5991);
            if (blockstate.method_28498((class_2769)class_2741.field_12529)) {
                axis = (class_2350.class_2351)blockstate.method_11654((class_2769)class_2741.field_12529);
                class_5459.class_5460 rectangle = class_5459.method_30574((class_2338)entity.field_5991, (class_2350.class_2351)axis, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, pos -> entity.field_6002.method_8320(pos) == blockstate);
                vector3d = class_2424.method_30494((class_5459.class_5460)rectangle, (class_2350.class_2351)axis, (class_243)entity.method_19538(), (class_4048)entity.method_18377(entity.method_18376()));
            } else {
                axis = class_2350.class_2351.field_11048;
                vector3d = new class_243(0.5, 0.0, 0.0);
            }
            return class_2424.method_30484((class_3218)level, (class_5459.class_5460)result, (class_2350.class_2351)axis, (class_243)vector3d, (class_4048)entity.method_18377(entity.method_18376()), (class_243)entity.method_18798(), (float)entity.method_36454(), (float)entity.method_36455());
        }).orElse(null);
    }

    protected Optional<class_5459.class_5460> getOrMakePortal(class_1297 entity, class_2338 pos, class_2784 border) {
        if (entity.field_5991.method_10264() > this.level.method_31600()) {
            return Optional.empty();
        }
        Optional<class_5459.class_5460> existingPortal = this.getExistingPortal(pos);
        if (existingPortal.isPresent()) {
            return existingPortal;
        }
        class_2350.class_2351 portalAxis = this.level.method_8320(entity.field_5991).method_28500(CeilandsPortalBlock.AXIS).orElse(class_2350.class_2351.field_11048);
        return this.makePortal(pos, portalAxis);
    }

    public static void attemptTeleport(class_3218 level, class_243 pos, class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            float yRot = player.method_36454();
            float xRot = player.method_36455();
            player.method_14251(level, pos.field_1352, pos.field_1351, pos.field_1350, yRot, xRot);
            player.method_30229();
            return;
        }
        class_1297 newEntity = entity.method_5864().method_5883((class_1937)level);
        if (newEntity == null) {
            return;
        }
        newEntity.method_30229();
        float f = class_3532.method_15363((float)entity.method_5791(), (float)-90.0f, (float)90.0f);
        newEntity.method_5878(entity);
        newEntity.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, entity.method_36454(), f);
        newEntity.method_5847(f);
        entity.method_31745(class_1297.class_5529.field_27002);
        level.method_18769(newEntity);
    }
}

