/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.fabric.worldgen.features.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4662;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7387;

public class CeiltrunkTreeFeature
extends class_3031<class_4643> {
    public CeiltrunkTreeFeature(Codec<class_4643> codecIn) {
        super(codecIn);
    }

    public static boolean isFree(class_3746 p_236410_0_, class_2338 p_236410_1_) {
        return CeiltrunkTreeFeature.validTreePos(p_236410_0_, p_236410_1_) || p_236410_0_.method_16358(p_236410_1_, p_236417_0_ -> p_236417_0_.method_26164(class_3481.field_15475));
    }

    private static boolean isVine(class_3746 p_236414_0_, class_2338 p_236414_1_) {
        return p_236414_0_.method_16358(p_236414_1_, p_236415_0_ -> p_236415_0_.method_27852(class_2246.field_10597));
    }

    private static boolean isBlockWater(class_3746 p_236416_0_, class_2338 p_236416_1_) {
        return p_236416_0_.method_16358(p_236416_1_, p_236413_0_ -> p_236413_0_.method_27852(class_2246.field_10382));
    }

    public static boolean isAirOrLeaves(class_3746 p_236412_0_, class_2338 p_236412_1_) {
        return p_236412_0_.method_16358(p_236412_1_, p_236411_0_ -> p_236411_0_.method_26215() || p_236411_0_.method_26164(class_3481.field_15503));
    }

    private static boolean isReplaceablePlant(class_3746 p_236419_0_, class_2338 p_236419_1_) {
        return p_236419_0_.method_16358(p_236419_1_, p_236406_0_ -> {
            class_3614 material = p_236406_0_.method_26207();
            return material == class_3614.field_15956;
        });
    }

    public static void setBlockKnownShape(class_1945 p_236408_0_, class_2338 p_236408_1_, class_2680 p_236408_2_) {
        p_236408_0_.method_8652(p_236408_1_, p_236408_2_, 19);
    }

    public static boolean validTreePos(class_3746 level, class_2338 pos) {
        return CeiltrunkTreeFeature.isAirOrLeaves(level, pos) || CeiltrunkTreeFeature.isReplaceablePlant(level, pos) || CeiltrunkTreeFeature.isBlockWater(level, pos);
    }

    private boolean doPlace(class_5281 level, class_5819 source, class_2338 pos, BiConsumer<class_2338, class_2680> p_225261_, BiConsumer<class_2338, class_2680> p_225262_, BiConsumer<class_2338, class_2680> p_225263_, class_4643 config) {
        int trunkHeight = config.field_24136.method_26993(source);
        int foliageHeight = config.field_24135.method_26989(source, trunkHeight, config);
        int k = trunkHeight + foliageHeight;
        int l = config.field_24135.method_23452(source, k);
        class_2338 blockpos = config.field_38767.map(rootplacer -> rootplacer.method_43309(pos, source)).orElse(pos);
        int i1 = Math.min(pos.method_10264(), blockpos.method_10264());
        int j1 = Math.max(pos.method_10264(), blockpos.method_10264()) + trunkHeight + 1;
        if (!CeiltrunkTreeFeature.isFree((class_3746)level, pos.method_10074())) {
            return false;
        }
        if (i1 >= level.method_31607() + 1 && j1 <= level.method_31600()) {
            OptionalInt optionalint = config.field_24137.method_27377();
            int k1 = this.getMaxFreeTreeHeight((class_3746)level, trunkHeight, blockpos, config);
            if (k1 >= -trunkHeight || !optionalint.isEmpty() && k1 >= optionalint.getAsInt()) {
                if (config.field_38767.isPresent() && !((class_7387)config.field_38767.get()).method_43168((class_3746)level, p_225261_, source, pos, blockpos, config)) {
                    return false;
                }
                List list = config.field_24136.method_26991((class_3746)level, p_225262_, source, k1, blockpos, config);
                list.forEach(p_225279_ -> config.field_24135.method_27385((class_3746)level, p_225263_, source, config, k1, p_225279_, foliageHeight, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(class_3746 reader, int height, class_2338 pos, class_4643 config) {
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (int i = 0; i <= height + 1; ++i) {
            int j = config.field_24137.method_27378(height, -i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutable.method_25504((class_2382)pos, k, -i, l);
                    if (CeiltrunkTreeFeature.isFree(reader, (class_2338)blockpos$mutable) && (config.field_24138 || !CeiltrunkTreeFeature.isVine(reader, (class_2338)blockpos$mutable))) continue;
                    return i - 2;
                }
            }
        }
        return height;
    }

    public final boolean method_13151(class_5821<class_4643> placeContxt) {
        class_5281 worldgenlevel = placeContxt.method_33652();
        class_5819 randomsource = placeContxt.method_33654();
        class_2338 blockpos = placeContxt.method_33655();
        class_4643 treeconfiguration = (class_4643)placeContxt.method_33656();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<class_2338, class_2680> biconsumer = (pos, state) -> {
            set.add(pos.method_10062());
            worldgenlevel.method_8652(pos, state, 19);
        };
        BiConsumer<class_2338, class_2680> biconsumer1 = (pos, state) -> {
            set1.add(pos.method_10062());
            worldgenlevel.method_8652(pos, state, 19);
        };
        BiConsumer<class_2338, class_2680> biconsumer2 = (pos, state) -> {
            set2.add(pos.method_10062());
            worldgenlevel.method_8652(pos, state, 19);
        };
        BiConsumer<class_2338, class_2680> biconsumer3 = (pos, state) -> {
            set3.add(pos.method_10062());
            worldgenlevel.method_8652(pos, state, 19);
        };
        boolean flag = this.doPlace(worldgenlevel, randomsource, blockpos, biconsumer, biconsumer1, biconsumer2, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.field_21290.isEmpty()) {
                class_4662.class_7402 treedecorator$context = new class_4662.class_7402((class_3746)worldgenlevel, biconsumer3, randomsource, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.field_21290.forEach(p_160528_ -> p_160528_.method_23469(treedecorator$context));
            }
            return class_3341.method_35411((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2)).map(p_160521_ -> {
                class_251 discretevoxelshape = CeiltrunkTreeFeature.updateLeaves((class_1936)worldgenlevel, p_160521_, set, set2);
                class_3499.method_20532((class_1936)worldgenlevel, (int)3, (class_251)discretevoxelshape, (int)p_160521_.method_35415(), (int)p_160521_.method_35416(), (int)p_160521_.method_35417());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static class_251 updateLeaves(class_1936 worldIn, class_3341 bbIn, Set<class_2338> p_236403_3_, Set<class_2338> p_236403_4_) {
        ArrayList list = Lists.newArrayList();
        class_244 discretevoxelshape = new class_244(bbIn.method_35414(), bbIn.method_14660(), bbIn.method_14663());
        int amt = 6;
        for (int j = 0; j < amt; ++j) {
            list.add(Sets.newHashSet());
        }
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (class_2338 blockpos : Lists.newArrayList(p_236403_4_)) {
            if (!bbIn.method_14662((class_2382)blockpos)) continue;
            discretevoxelshape.method_1049(blockpos.method_10263() - bbIn.method_35415(), blockpos.method_10264() - bbIn.method_35416(), blockpos.method_10260() - bbIn.method_35417());
        }
        for (class_2338 blockpos1 : Lists.newArrayList(p_236403_3_)) {
            if (bbIn.method_14662((class_2382)blockpos1)) {
                discretevoxelshape.method_1049(blockpos1.method_10263() - bbIn.method_35415(), blockpos1.method_10264() - bbIn.method_35416(), blockpos1.method_10260() - bbIn.method_35417());
            }
            for (class_2350 direction : class_2350.values()) {
                class_2680 blockstate;
                blockpos$mutable.method_25505((class_2382)blockpos1, direction);
                if (p_236403_3_.contains(blockpos$mutable) || !(blockstate = worldIn.method_8320((class_2338)blockpos$mutable)).method_28498((class_2769)class_2741.field_12541)) continue;
                ((Set)list.get(0)).add(blockpos$mutable.method_10062());
                CeiltrunkTreeFeature.setBlockKnownShape((class_1945)worldIn, (class_2338)blockpos$mutable, (class_2680)blockstate.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                if (!bbIn.method_14662((class_2382)blockpos$mutable)) continue;
                discretevoxelshape.method_1049(blockpos$mutable.method_10263() - bbIn.method_35415(), blockpos$mutable.method_10264() - bbIn.method_35416(), blockpos$mutable.method_10260() - bbIn.method_35417());
            }
        }
        for (int l = 1; l < amt; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (class_2338 blockpos2 : set) {
                if (bbIn.method_14662((class_2382)blockpos2)) {
                    discretevoxelshape.method_1049(blockpos2.method_10263() - bbIn.method_35415(), blockpos2.method_10264() - bbIn.method_35416(), blockpos2.method_10260() - bbIn.method_35417());
                }
                for (class_2350 direction1 : class_2350.values()) {
                    int k;
                    class_2680 blockstate1;
                    blockpos$mutable.method_25505((class_2382)blockpos2, direction1);
                    if (set.contains(blockpos$mutable) || set1.contains(blockpos$mutable) || !(blockstate1 = worldIn.method_8320((class_2338)blockpos$mutable)).method_28498((class_2769)class_2741.field_12541) || (k = ((Integer)blockstate1.method_11654((class_2769)class_2741.field_12541)).intValue()) <= l + 1) continue;
                    class_2680 blockstate2 = (class_2680)blockstate1.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(l + 1));
                    CeiltrunkTreeFeature.setBlockKnownShape((class_1945)worldIn, (class_2338)blockpos$mutable, blockstate2);
                    if (bbIn.method_14662((class_2382)blockpos$mutable)) {
                        discretevoxelshape.method_1049(blockpos$mutable.method_10263() - bbIn.method_35415(), blockpos$mutable.method_10264() - bbIn.method_35416(), blockpos$mutable.method_10260() - bbIn.method_35417());
                    }
                    set1.add(blockpos$mutable.method_10062());
                }
            }
        }
        return discretevoxelshape;
    }
}

