/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.block;

import com.kittehmod.ceilands.forge.registry.CeilandsBlocks;
import com.kittehmod.ceilands.forge.registry.CeilandsDimension;
import com.kittehmod.ceilands.forge.tags.CeilandsBlockTags;
import com.kittehmod.ceilands.forge.util.CeilandsPortalHelper;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeilandsPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final int AABB_OFFSET = 2;
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public CeilandsPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public BlockState m_7417_(BlockState currentState, Direction dir, BlockState newState, LevelAccessor level, BlockPos pos1, BlockPos pos2) {
        Direction.Axis $$6 = dir.m_122434_();
        Direction.Axis $$7 = (Direction.Axis)currentState.m_61143_(AXIS);
        boolean $$8 = $$7 != $$6 && $$6.m_122479_();
        return !$$8 && !newState.m_60713_((Block)this) && !new PortalShape(level, pos1, $$7).m_77744_() ? Blocks.f_50016_.m_49966_() : super.m_7417_(currentState, dir, newState, level, pos1, pos2);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    public boolean canPortalBlockStay(LevelAccessor level, BlockPos pos) {
        boolean flag = true;
        if (!level.m_8055_(pos.m_7494_()).m_204336_(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS) && !level.m_8055_(pos.m_7494_()).m_60713_(CeilandsBlocks.CEILANDS_PORTAL)) {
            flag = false;
        }
        if (!level.m_8055_(pos.m_7495_()).m_204336_(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS) && !level.m_8055_(pos.m_7495_()).m_60713_(CeilandsBlocks.CEILANDS_PORTAL)) {
            flag = false;
        }
        if (!level.m_8055_(pos.m_5484_(Direction.m_122387_((Direction.Axis)((Direction.Axis)level.m_8055_(pos).m_61143_(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 1)).m_204336_(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS) && !level.m_8055_(pos.m_5484_(Direction.m_122387_((Direction.Axis)((Direction.Axis)level.m_8055_(pos).m_61143_(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 1)).m_60713_(CeilandsBlocks.CEILANDS_PORTAL)) {
            flag = false;
        }
        if (!level.m_8055_(pos.m_5484_(Direction.m_122387_((Direction.Axis)((Direction.Axis)level.m_8055_(pos).m_61143_(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE), 1)).m_204336_(CeilandsBlockTags.CEILANDS_PORTAL_FRAME_BLOCKS) && !level.m_8055_(pos.m_5484_(Direction.m_122387_((Direction.Axis)((Direction.Axis)level.m_8055_(pos).m_61143_(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE), 1)).m_60713_(CeilandsBlocks.CEILANDS_PORTAL)) {
            flag = false;
        }
        return flag;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.m_5776_() && !entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            if (entity.m_20092_()) {
                return;
            }
            if (entity.f_19818_ < 190) {
                entity.f_19818_ += 2;
            } else {
                entity.f_19818_ = 0;
                entity.f_19819_ = pos.m_7949_();
                entity.m_20091_();
                this.handleCeilandsPortal(state, level, pos, entity);
            }
        } else if (level.m_5776_() && entity instanceof Player) {
            ((LocalPlayer)entity).m_20221_(pos);
        }
    }

    private void handleCeilandsPortal(BlockState state, Level level, BlockPos pos, Entity entity) {
        ResourceKey<Level> levelToChoose;
        MinecraftServer minecraftserver = ((ServerLevel)level).m_7654_();
        ServerLevel destinationWorld = minecraftserver.m_129880_(levelToChoose = entity.m_9236_() == minecraftserver.m_129880_(CeilandsDimension.CEILANDS) ? Level.f_46428_ : CeilandsDimension.CEILANDS);
        if (destinationWorld == null) {
            return;
        }
        CeilandsPortalHelper helper = new CeilandsPortalHelper(destinationWorld);
        PortalInfo portalInfo = helper.getPortalInfo(entity, destinationWorld, null);
        CeilandsPortalHelper.attemptTeleport(destinationWorld, portalInfo.f_77676_, entity);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(100) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() + random.m_188500_();
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            double d3 = ((double)random.m_188501_() - 0.5) * 0.5;
            double d4 = ((double)random.m_188501_() - 0.5) * 0.5;
            double d5 = ((double)random.m_188501_() - 0.5) * 0.5;
            int j = random.m_188503_(2) * 2 - 1;
            if (!level.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !level.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                d3 = random.m_188501_() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                d5 = random.m_188501_() * 2.0f * (float)j;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    public ItemStack m_7397_(BlockGetter p_54911_, BlockPos p_54912_, BlockState p_54913_) {
        return ItemStack.f_41583_;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }
}

