/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.kittehmod.ceilands.forge.entity.ModBoat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;

public class CeilandsBoatRenderer
extends EntityRenderer<ModBoat> {
    private final Map<ModBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public CeilandsBoatRenderer(EntityRendererProvider.Context context, boolean isChest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(ModBoat.Type.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, p_234575_ -> Pair.of((Object)new ResourceLocation("ceilands", CeilandsBoatRenderer.getTextureLocation(p_234575_, isChest)), (Object)this.createBoatModel(context, (ModBoat.Type)((Object)p_234575_), isChest))));
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, ModBoat.Type boatType, boolean isChest) {
        ModelLayerLocation modellayerlocation = isChest ? CeilandsBoatRenderer.createChestBoatModelName(boatType) : CeilandsBoatRenderer.createBoatModelName(boatType);
        return new BoatModel(context.m_174023_(modellayerlocation), isChest);
    }

    private static String getTextureLocation(ModBoat.Type boatType, boolean isChest) {
        return isChest ? "textures/entity/chest_boat/" + boatType.getName() + ".png" : "textures/entity/boat/" + boatType.getName() + ".png";
    }

    public void render(ModBoat entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float f2;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.375, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float f = (float)entityIn.m_38385_() - partialTicks;
        float f1 = entityIn.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entityIn.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = entityIn.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStackIn.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entityIn.m_38352_(partialTicks), true));
        }
        Pair<ResourceLocation, BoatModel> pair = this.getModelWithLocation(entityIn);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        BoatModel boatmodel = (BoatModel)pair.getSecond();
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        boatmodel.m_6973_((Boat)entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(boatmodel.m_103119_(resourcelocation));
        boatmodel.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entityIn.m_5842_()) {
            VertexConsumer vertexconsumer1 = bufferIn.m_6299_(RenderType.m_110478_());
            boatmodel.m_102282_().m_104301_(matrixStackIn, vertexconsumer1, packedLightIn, OverlayTexture.f_118083_);
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(ModBoat entity) {
        switch (entity.getCeilandsBoatType()) {
            case CEILTRUNK: {
                return new ResourceLocation("ceilands:textures/entity/boat/ceiltrunk.png");
            }
        }
        return new ResourceLocation("ceilands:textures/entity/boat/luzawood.png");
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(ModBoat boat) {
        return this.boatResources.get((Object)boat.getCeilandsBoatType());
    }

    private static ModelLayerLocation createLocation(String path, String p_171302_) {
        return new ModelLayerLocation(new ResourceLocation("minecraft", path), p_171302_);
    }

    public static ModelLayerLocation createBoatModelName(ModBoat.Type p_171290_) {
        return CeilandsBoatRenderer.createLocation("boat/oak", "main");
    }

    public static ModelLayerLocation createChestBoatModelName(ModBoat.Type p_233551_) {
        return CeilandsBoatRenderer.createLocation("chest_boat/oak", "main");
    }
}

