/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.forge;

import com.google.common.collect.ImmutableList;
import com.kittehmod.ceilands.forge.block.ModWoodType;
import com.kittehmod.ceilands.forge.forge.CeilandsRegistry;
import com.kittehmod.ceilands.forge.forge.CompatsForge;
import com.kittehmod.ceilands.forge.forge.client.ClientHandler;
import com.kittehmod.ceilands.forge.forge.compat.BoatloadCompat;
import com.kittehmod.ceilands.forge.forge.compat.FarmersDelightCompat;
import com.kittehmod.ceilands.forge.forge.compat.TwilightForestCompat;
import com.kittehmod.ceilands.forge.forge.compat.WoodworksCompat;
import com.kittehmod.ceilands.forge.registry.CeilandsGameRules;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.resource.PathPackResources;
import oshi.util.tuples.Quartet;

@Mod(value="ceilands")
public class CeilandsModForge {
    public CeilandsModForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register(CeilandsRegistry.class);
        bus.addListener(this::setupCommon);
        this.hookCompats(bus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.addListener(this::setupClient);
        }
        bus.addListener(this::setupDataPacks);
    }

    private void hookCompats(IEventBus bus) {
        if (CompatsForge.FARMERS_DELIGHT_INSTALLED) {
            bus.register((Object)new FarmersDelightCompat(false));
        }
        if (CompatsForge.TWILIGHT_FOREST_INSTALLED) {
            bus.register((Object)new TwilightForestCompat(false));
        }
        if (CompatsForge.WOODWORKS_INSTALLED) {
            bus.register((Object)new WoodworksCompat(false));
        }
        if (CompatsForge.BOATLOAD_INSTALLED) {
            bus.register((Object)new BoatloadCompat(false));
        }
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        CeilandsGameRules.setup();
        event.enqueueWork(() -> WoodType.m_61844_((WoodType)ModWoodType.CEILTRUNK));
        event.enqueueWork(() -> WoodType.m_61844_((WoodType)ModWoodType.LUZAWOOD));
        event.enqueueWork(() -> CeilandsRegistry.registerFlammable());
        event.enqueueWork(() -> CeilandsRegistry.registerFlowerPots());
    }

    private void setupClient(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ClientHandler.class);
        ClientHandler.setupRenderers();
        event.enqueueWork(() -> Sheets.addWoodType((WoodType)ModWoodType.CEILTRUNK));
        event.enqueueWork(() -> Sheets.addWoodType((WoodType)ModWoodType.LUZAWOOD));
    }

    public void setupDataPacks(AddPackFindersEvent event) {
        Quartet packFarmersDelight = new Quartet((Object)"farmersdelight", (Object)CompatsForge.FARMERS_DELIGHT_INSTALLED, (Object)"datapacks/ceilands_fd_compat", (Object)"Ceilands - Farmers Delight Pack");
        Quartet packTwilightForest = new Quartet((Object)"twilightforet", (Object)CompatsForge.TWILIGHT_FOREST_INSTALLED, (Object)"datapacks/ceilands_tf_compat", (Object)"Ceilands - Twilight Forest Pack");
        Quartet packBoatload = new Quartet((Object)"boatload", (Object)CompatsForge.BOATLOAD_INSTALLED, (Object)"datapacks/ceilands_boatload_compat", (Object)"Ceilands - Boatload Pack");
        Quartet packWoodworks = new Quartet((Object)"woodworks", (Object)CompatsForge.WOODWORKS_INSTALLED, (Object)"datapacks/ceilands_woodworks_compat", (Object)"Ceilands - Woodworks Pack");
        ImmutableList packs = ImmutableList.of((Object)packFarmersDelight, (Object)packTwilightForest, (Object)packBoatload, (Object)packWoodworks);
        if (event.getPackType() == PackType.SERVER_DATA) {
            for (Quartet packToCheck : packs) {
                if (!((Boolean)packToCheck.getB()).booleanValue()) continue;
                Path resourcePath = ModList.get().getModFileById("ceilands").getFile().findResource(new String[]{(String)packToCheck.getC()});
                try (PathPackResources pack = new PathPackResources(ModList.get().getModFileById("ceilands").getFile().getFileName() + ":" + String.valueOf(resourcePath), resourcePath);){
                    PackMetadataSection metadataSection = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
                    if (metadataSection == null) continue;
                    event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/ceilands-" + (String)packToCheck.getA(), (Component)Component.m_237113_((String)((String)packToCheck.getD())), false, () -> pack, metadataSection, Pack.Position.BOTTOM, PackSource.f_10528_, false)));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

