/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.worldgen.features;

import com.kittehmod.ceilands.forge.util.MathHelper;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class ColossalCeilshroom
extends Feature<BlockStateConfiguration> {
    public ColossalCeilshroom(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStateConfiguration> context) {
        boolean shouldPlace = false;
        BlockPos blockpos = context.m_159777_();
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        for (int i = 1; i < 96; ++i) {
            if (!worldgenlevel.m_8055_(blockpos.m_6630_(i)).m_204336_(BlockTags.f_144274_)) continue;
            blockpos = blockpos.m_6630_(i);
            shouldPlace = true;
            break;
        }
        if (!shouldPlace) {
            return false;
        }
        boolean genShroomlights = (double)randomsource.m_188501_() < 0.1;
        boolean genLush = (double)randomsource.m_188501_() < 0.25;
        int stemRadius = 2 + randomsource.m_188503_(5);
        int stemHeight = stemRadius * (3 + randomsource.m_188503_(7));
        int stemTaperThreshold = 3 + randomsource.m_188503_(2);
        int stemTaperThreshold2 = (double)randomsource.m_188501_() < 0.5 ? stemTaperThreshold * 2 + randomsource.m_188503_(4) : -1;
        for (int stemY = 0; stemY < stemHeight; ++stemY) {
            for (int stemX = -stemRadius; stemX < stemRadius; ++stemX) {
                for (int stemZ = -stemRadius; stemZ < stemRadius; ++stemZ) {
                    if ((stemX <= -stemRadius || stemX >= stemRadius - 1) && (stemZ <= -stemRadius || stemZ >= stemRadius - 1) || worldgenlevel.m_8055_(blockpos.m_6625_(stemY).m_122030_(stemX).m_122020_(stemZ)).m_60734_() != Blocks.f_50016_) continue;
                    this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(stemY).m_122030_(stemX).m_122020_(stemZ), Blocks.f_50182_.m_49966_());
                }
            }
            if (stemY == stemTaperThreshold) {
                --stemRadius;
            }
            if (stemTaperThreshold2 > 0 && stemY == stemTaperThreshold2) {
                --stemRadius;
            }
            if (stemRadius >= 2) continue;
            stemRadius = 2;
        }
        blockpos = blockpos.m_6625_(stemHeight);
        Block capBlock = (double)randomsource.m_188501_() < 0.5 ? Blocks.f_50181_ : Blocks.f_50180_;
        Block lushBlock = (double)randomsource.m_188501_() < 0.3 ? Blocks.f_152544_ : Blocks.f_50440_;
        int capRadius = 5 + stemRadius * 4 + randomsource.m_188503_(5);
        int capThickness = 3 + (int)Math.floor(capRadius / 5 + randomsource.m_188503_(8));
        if (capRadius > 16) {
            capRadius = 16;
        }
        for (int capY = 0; capY < capThickness; ++capY) {
            for (int capX = -capRadius; capX < capRadius; ++capX) {
                for (int capZ = -capRadius; capZ < capRadius; ++capZ) {
                    if (!MathHelper.isPlotInCircle(capX, capZ, capRadius) || worldgenlevel.m_8055_(blockpos.m_6625_(capY).m_122030_(capX).m_122020_(capZ)) != Blocks.f_50016_.m_49966_()) continue;
                    this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(capY).m_122030_(capX).m_122020_(capZ), capBlock.m_49966_());
                    if (genLush && capY == 0 && capX > -capRadius + 2 && capX < capRadius - 2 && capZ > -capRadius + 2 && capZ < capRadius - 2 && MathHelper.isPlotInCircle(capX, capZ, capRadius - 2) && worldgenlevel.m_8055_(blockpos.m_6625_(capY).m_122030_(capX).m_122020_(capZ)).m_60734_() != Blocks.f_50182_) {
                        this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(capY).m_122030_(capX).m_122020_(capZ), lushBlock.m_49966_());
                    }
                    if (!genShroomlights || !((double)randomsource.m_188501_() < 0.02)) continue;
                    this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(capY).m_122030_(capX).m_122020_(capZ), Blocks.f_50701_.m_49966_());
                }
            }
            if (capY < 1) continue;
            if (capBlock == Blocks.f_50181_) {
                capRadius -= Math.min(capY + 1, 5);
                continue;
            }
            capRadius = (int)((double)capRadius - Math.max((double)capRadius * 0.15, 1.0));
        }
        return true;
    }
}

