/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.worldgen.features;

import com.kittehmod.ceilands.forge.registry.CeilandsBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class ColossalCeiltrunkTree
extends Feature<BlockStateConfiguration> {
    public ColossalCeiltrunkTree(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStateConfiguration> context) {
        int i;
        BlockPos blockpos = context.m_159777_();
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        boolean foundSpace = false;
        boolean isOKToPutLog = false;
        for (i = 1; i < 6; ++i) {
            if (worldgenlevel.m_8055_(blockpos.m_6625_(i)).m_60734_() == Blocks.f_50016_ || worldgenlevel.m_8055_(blockpos.m_6625_(i)).m_204336_(BlockTags.f_144275_)) continue;
            blockpos = blockpos.m_6625_(i);
            foundSpace = true;
            break;
        }
        for (i = 1; i < 6 && !foundSpace; ++i) {
            if (worldgenlevel.m_8055_(blockpos.m_6630_(i)).m_60734_() == Blocks.f_50016_ || worldgenlevel.m_8055_(blockpos.m_6630_(i)).m_204336_(BlockTags.f_144275_)) continue;
            blockpos = blockpos.m_6630_(i);
            foundSpace = true;
            break;
        }
        if (!foundSpace) {
            return false;
        }
        int trunkRadius = 2 + randomsource.m_188503_(3);
        int trunkHeight = 4 + trunkRadius * (3 + randomsource.m_188503_(7));
        int branchLength = 2 + trunkRadius + randomsource.m_188503_(3);
        for (int trunkX = -trunkRadius; trunkX < trunkRadius; ++trunkX) {
            for (int trunkZ = -trunkRadius; trunkZ < trunkRadius; ++trunkZ) {
                if ((trunkX <= -trunkRadius || trunkX >= trunkRadius - 1) && (trunkZ <= -trunkRadius || trunkZ >= trunkRadius - 1) || worldgenlevel.m_8055_(blockpos.m_6630_(1).m_122030_(trunkX).m_122020_(trunkZ)).m_60734_() != Blocks.f_50016_ && !worldgenlevel.m_8055_(blockpos.m_6625_(0).m_122030_(trunkX).m_122020_(trunkZ)).m_204336_(BlockTags.f_144275_) && !worldgenlevel.m_8055_(blockpos.m_6625_(0).m_122030_(trunkX).m_122020_(trunkZ)).m_60713_(CeilandsBlocks.CEILTRUNK_LEAVES)) continue;
                this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6630_(1).m_122030_(trunkX).m_122020_(trunkZ), Blocks.f_152544_.m_49966_());
            }
        }
        for (int trunkY = 0; trunkY < trunkHeight; ++trunkY) {
            for (int trunkX = -trunkRadius; trunkX < trunkRadius; ++trunkX) {
                for (int trunkZ = -trunkRadius; trunkZ < trunkRadius; ++trunkZ) {
                    isOKToPutLog = false;
                    if ((trunkX == -trunkRadius + 1 || trunkX == trunkRadius - 2) && (trunkZ == -trunkRadius + 1 || trunkZ == trunkRadius - 2) || trunkY < Mth.m_14143_((float)Mth.m_14116_((float)(trunkHeight / 4)))) {
                        isOKToPutLog = true;
                    }
                    if (trunkX > -trunkRadius + 1 && trunkX < trunkRadius - 2 || trunkZ > -trunkRadius + 1 && trunkZ < trunkRadius - 2) {
                        isOKToPutLog = true;
                    }
                    if (!isOKToPutLog || worldgenlevel.m_8055_(blockpos.m_6625_(trunkY).m_122030_(trunkX).m_122020_(trunkZ)).m_60734_() != Blocks.f_50016_ && !worldgenlevel.m_8055_(blockpos.m_6625_(trunkY).m_122030_(trunkX).m_122020_(trunkZ)).m_204336_(BlockTags.f_144275_) && !worldgenlevel.m_8055_(blockpos.m_6625_(trunkY).m_122030_(trunkX).m_122020_(trunkZ)).m_60713_(CeilandsBlocks.CEILTRUNK_LEAVES)) continue;
                    this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(trunkY).m_122030_(trunkX).m_122020_(trunkZ), CeilandsBlocks.CEILTRUNK_LOG.m_49966_());
                }
            }
        }
        Direction dir = Direction.NORTH;
        boolean clockwise = (double)randomsource.m_188501_() >= 0.5;
        for (int i2 = 2; i2 < trunkHeight - 2; ++i2) {
            this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(i2), dir, branchLength, dir.m_122434_() == Direction.Axis.X ? (dir == Direction.EAST ? trunkRadius - 1 : -trunkRadius) : 0, dir.m_122434_() == Direction.Axis.Z ? (dir == Direction.SOUTH ? trunkRadius - 1 : -trunkRadius) : 0, 1);
            dir = clockwise ? dir.m_122427_() : dir.m_122428_();
        }
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.NORTH, branchLength, -2, -trunkRadius + 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.NORTH, branchLength, -1, -trunkRadius + 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.NORTH, branchLength, 1, -trunkRadius + 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.NORTH, branchLength, 2, -trunkRadius + 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.EAST, branchLength, trunkRadius - 2, -2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.EAST, branchLength, trunkRadius - 2, -1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.EAST, branchLength, trunkRadius - 2, 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.EAST, branchLength, trunkRadius - 2, 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.SOUTH, branchLength, -2, trunkRadius - 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.SOUTH, branchLength, -1, trunkRadius - 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.SOUTH, branchLength, 1, trunkRadius - 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.SOUTH, branchLength, 2, trunkRadius - 2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.WEST, branchLength, -trunkRadius + 1, -2, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.WEST, branchLength, -trunkRadius + 1, -1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.WEST, branchLength, -trunkRadius + 1, 1, 2);
        this.generateBranches(worldgenlevel, randomsource, blockpos.m_6625_(trunkHeight), Direction.WEST, branchLength, -trunkRadius + 1, 2, 2);
        return true;
    }

    private void generateBranches(WorldGenLevel level, RandomSource random, BlockPos pos, Direction direction, int branchLength, int offsetX, int offsetZ, int foliageRadius) {
        for (int bl = 1; bl <= branchLength; ++bl) {
            this.m_5974_((LevelWriter)level, pos.m_5484_(direction, bl).m_122030_(offsetX).m_122020_(offsetZ), (BlockState)CeilandsBlocks.CEILTRUNK_LOG.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
            if (bl == branchLength - 1) {
                this.m_5974_((LevelWriter)level, pos.m_5484_(direction, bl).m_122030_(offsetX).m_122020_(offsetZ).m_6630_(1), (BlockState)CeilandsBlocks.CEILTRUNK_LOG.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y));
            }
            this.setSurroundingBlocks(level, pos.m_5484_(direction, bl).m_122030_(offsetX).m_122020_(offsetZ), CeilandsBlocks.CEILTRUNK_LEAVES.m_49966_(), foliageRadius);
        }
    }

    private void setSurroundingBlocks(WorldGenLevel level, BlockPos pos, BlockState state, int radius) {
        for (Direction dir : Direction.values()) {
            for (int i = 0; i <= radius; ++i) {
                if (level.m_8055_(pos.m_5484_(dir, i)).m_60734_() != Blocks.f_50016_ || !(state.m_60734_() instanceof LeavesBlock)) continue;
                this.m_5974_((LevelWriter)level, pos.m_5484_(dir, i), (BlockState)state.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(i + 1)));
            }
        }
    }
}

