/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.worldgen.features;

import com.kittehmod.ceilands.forge.registry.CeilandsBlocks;
import com.kittehmod.ceilands.forge.util.MathHelper;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class LargeFloatingIslandFeature
extends Feature<BlockStateConfiguration> {
    public LargeFloatingIslandFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStateConfiguration> context) {
        BlockPos blockpos = context.m_159777_();
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        int radius = 12 + randomsource.m_188503_(5);
        int height = radius / 2 + randomsource.m_188503_(12);
        int taperingAmt = height > radius ? 2 : 1;
        int taperingSteps = (double)height * 0.5 < (double)radius ? 2 : 1;
        boolean hasPond = (double)randomsource.m_188501_() < 0.2;
        int pondDepth = hasPond ? randomsource.m_188503_(3) : 0;
        int pondWidth = hasPond ? pondDepth * 2 + randomsource.m_188503_(4) + 1 : 0;
        for (int posY = 0; posY < height; ++posY) {
            if (posY == 0) {
                --radius;
            }
            if (posY == 1) {
                ++radius;
            }
            for (int posX = -radius; posX < radius; ++posX) {
                for (int posZ = -radius; posZ < radius; ++posZ) {
                    if (MathHelper.isPlotInCircle(posX, posZ, radius) && worldgenlevel.m_8055_(blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ)).m_60734_() == Blocks.f_50016_) {
                        if (posY == 0) {
                            this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ), Blocks.f_50440_.m_49966_());
                        } else if (posY == 1) {
                            this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ), Blocks.f_50493_.m_49966_());
                        } else if (posY == 2 && (double)randomsource.m_188501_() < 0.5) {
                            this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ), Blocks.f_50493_.m_49966_());
                        } else if (posY == 3 && (double)randomsource.m_188501_() < 0.25) {
                            this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ), Blocks.f_50493_.m_49966_());
                        } else {
                            this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ), CeilandsBlocks.CEILINGNEOUS.m_49966_());
                        }
                    }
                    if (!hasPond || !MathHelper.isPlotInCircle(posX, posZ, pondWidth) || posY > pondDepth) continue;
                    this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ), Blocks.f_49990_.m_49966_());
                    this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY + 1).m_122030_(posX).m_122020_(posZ), Blocks.f_49992_.m_49966_());
                }
            }
            if (pondWidth > 0) {
                --pondWidth;
            }
            if (posY % taperingSteps == 0) {
                radius -= taperingAmt;
            }
            if (radius <= 0) break;
        }
        return true;
    }
}

